<?= $this->extend("layouts/base");?>
<?= $this->section("content");?>
<style>
#pageloader {
    background: rgba(255, 255, 255, 0.8);
    display: none;
    height: 100%;
    position: fixed;
    width: 100%;
    z-index: 9999;
}

#pageloader img {
    left: 50%;
    margin-left: -32px;
    margin-top: -32px;
    position: absolute;
    top: 50%;
}
</style>
<script src="<?php echo base_url(); ?>/public/assets/js/jquery-2.2.4.min.js"></script>
<script src="<?php echo base_url(); ?>/public/assets/js/jquery.multi-select.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" />
<div class="main-content container-fluid">
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h3><?= $page_title; ?></h3>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first">
            </div>
        </div>
    </div>
    <section class="section">
        <div class="card">
            <div class="card-body">
                <div class="row match-height">
                    <div id="pageloader">
                        <img src="http://cdnjs.cloudflare.com/ajax/libs/semantic-ui/0.16.1/images/loader-large.gif"
                            alt="processing..." />
                    </div>
                    <div class="px-4 mb-4">
                        <form method="post" id="formId"
                            action="<?php echo base_url();?>/<?php echo (isset($activitydetails))?'Update-Program-Campaining':'Add-Program-Campaign'; ?>"
                            enctype=multipart/form-data>
                            <?= csrf_field(); ?>
                            <div class="container-fluid my-4 mb-5">
                                <div class="col-md-12">
                                    <h5>Campaign Details</h5>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Activity Name<span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10">
                                            <input type="text" id="ActivityName" required maxlength="250"
                                                value="<?= (isset($activitydetails))?$activitydetails['ActivityName']:set_value('ActivityName'); ?>"
                                                name="ActivityName"
                                                class="form-control activityName col-md-4 p-2 col-12"
                                                placeholder="Max 80 characters">
                                            <span
                                                class="text-danger"><?= isset($validation) ? display_error($validation,'ActivityName') : ''?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Activity Type<span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10">
                                            <select id="ActivityType" required name="ActivityType"
                                                class="form-control ActivityType col-md-4 p-2 col-12">
                                                <option <?= set_select('ActivityType','Campaign')?> value="Campaign">
                                                    Campaign</option>
                                                <option <?= set_select('ActivityType','Committee Meeting')?>
                                                    value="Committee Meeting">Committee Meeting</option>
                                                <option <?= set_select('ActivityType','Committee Recruitment')?>
                                                    value="Committee Recruitment">Committee Recruitment</option>
                                                <option <?= set_select('ActivityType','Event')?> value="Event">Event
                                                </option>
                                                <option <?= set_select('ActivityType','Others')?> value="Others">Others
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2   fw-bolder">
                                            Instructions<span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10">
                                            <textarea id="instructions" maxlength="10000" required name="Instructions"
                                                class="form-control instruction col-md-8 p-2 col-12"
                                                placeholder="Upto 10000  Words" rows="4"
                                                cols="50"><?=  (isset($activitydetails))?$activitydetails['Instructions']:set_value('Instructions'); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2   fw-bolder">
                                            Links
                                        </div>
                                        <div class="col-md-10">
                                            <input type="url" name="links" id="links"
                                                class="form-control instruction col-md-4 p-2 col-12" placeholder="Url"
                                                value="<?=  (isset($activitydetails))?$activitydetails['Links']:set_value('Links'); ?>">

                                            <!--    <textarea id="links" name="Links"    class="form-control links col-md-8 p-2 col-12"
                                placeholder="Any Uselful references like songs etc." rows="4" cols="50"><?= (isset($activitydetails))?$activitydetails['Links']:set_value('Links'); ?></textarea> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Status<span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10">
                                            <select id="status" required name="ActivityStatus"
                                                class="form-control status col-md-4 p-2 col-12">
                                                <option <?= set_select('ActivityStatus','Open')?> value="Open">Open
                                                </option>
                                                <option <?= set_select('ActivityStatus','Close')?> value="Close">Close
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Target Completion Date
                                        </div>
                                        <div class="col-md-10">
                                            <input type="date" min="<?php echo date('Y-m-d'); ?>"
                                                name="TargetCompletionDate" required id="TargetCompletionDate"
                                                value="<?= (isset($activitydetails))?$activitydetails['TargetCompletionDate']:set_value('TargetCompletionDate'); ?>"
                                                class="form-control tcd col-md-4 p-2 col-12">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 col-lg-2 align-self-center fw-bolder">
                                            Designated Member <span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10 col-lg-10">
                                            <select required class="col-md-4 col-lg-4 p-2 col-12" id="designatedMember"
                                                name="designatedMember">
                                                <option value="">Please Select</option>
                                                <option value="Yes"
                                                    <?php  if(isset($activitydetails)){  if($activitydetails['designatedMember'] == "Yes"){ echo 'Selected';} } ?>>
                                                    Yes</option>
                                                <option value="No"
                                                    <?php  if(isset($activitydetails)){ if($activitydetails['designatedMember'] == "No"){ echo 'Selected';} } ?>>
                                                    No</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 col-lg-2 align-self-center fw-bolder">
                                            Committee <span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10 col-lg-10">
                                            <select required class="col-md-4 col-lg-4 p-2 col-12" multiple
                                                id="committeeNameId" name="committeeNameId[]">
                                                <?php 
                                                                    if(isset($activitydetails)){ 
                                                                    foreach($committeeName as $row){ ?>
                                                <option <?php  

                                                                    if(isset($activitydetails)){ 
                                                                        if($activitydetails){
                                                                            $s=explode(",",$activitydetails['committeeNameIdS']);
                                                                                if(in_array($row['committeeNameId'],$s)){
                                                                                    echo 'selected';
                                                                                }
                                                                        } }else{
                                                                            echo set_select('affiliatedCommitteeId[]',$row['affiliatedCommitteeId']);
                                                                    } ?> value="<?= $row['committeeNameId'];?>">
                                                    <?= $row['committeeName'];?></option>
                                                <?php } }?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <span id="ShowHide">
                                    <div class="col-md-12 my-3">
                                        <div class="row">
                                            <div class="col-md-2 col-lg-2 align-self-center fw-bolder">
                                                Committee Type <span style="color: red;"><b>*</b></span>
                                            </div>
                                            <div class="col-md-10 col-lg-10">
                                                <!--<select class="col-md-12 col-lg-6 p-2 col-12" multiple id="committeeTypeId"
                                                            name="committeeTypeId">
                                                            <option value="">Please Select</option>  
                                                            <?php /*  if(isset($committeeType)){
                                                                foreach($committeeType as $row){ ?> 
                                                                        <option <?php if($activitydetails['committeeTypeId'] == $row['committeeTypeId']){ echo 'Selected';}?> value="<?= $row['committeeTypeId'];?>"><?= $row['committeeTypeName'];?></option>
                                                                <?php }
                                                            } */?> 
                                                               
                                                        </select> -->
                                                <select required class="col-md-4 col-lg-4 p-2 col-12"
                                                    id="committeeTypeId" name="committeeTypeId">
                                                    <option value="">Please Select</option>
                                                    <option value="Main"
                                                        <?php if(isset($activitydetails)){  if($activitydetails['committeeTypeId'] == "Main"){ echo 'Selected';} }?>>
                                                        Main</option>
                                                    <option value="Affiliated"
                                                        <?php if(isset($activitydetails)){  if($activitydetails['committeeTypeId'] == "Affiliated"){ echo 'Selected';} }?>>
                                                        Affiliated</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 my-3">
                                        <div class="row" id="designationOrAffiliated_Committees">
                                            <div class="col-md-2 col-lg-2 align-self-center fw-bolder">
                                                Affiliated Committee
                                            </div>
                                            <div class="col-md-10 col-lg-10">
                                                <select multiple class="col-md-4 col-lg-4 p-2 col-12"
                                                    id="affiliatedCommitteeId" name="affiliatedCommitteeId[]"
                                                    onchange="getValue(this);">
                                                    <!-- <option value="">Please Select</option> -->
                                                    <?php   if(isset($affiliatedCommittees)){
                                                            foreach($affiliatedCommittees as $row){ ?>
                                                    <option <?php  
                                                                    if(isset($activitydetails)){ 
                                                                        if($activitydetails){
                                                                            $s=explode(",",$activitydetails['affiliatedCommitteeIds']);
                                                                                if(in_array($row['affiliatedCommitteeId'],$s)){
                                                                                    echo 'selected';
                                                                                }
                                                                        } }else{
                                                                            echo set_select('affiliatedCommitteeId[]',$row['affiliatedCommitteeId']);
                                                                    }
                                                                    ?> value="<?= $row['affiliatedCommitteeId'];?>">
                                                        <?= $row['affiliatedCommitteeName'];?></option>
                                                    <?php }
                                                            }?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 my-3">
                                        <div class="row">
                                            <div class="col-md-2 col-lg-2 align-self-center fw-bolder">
                                                Designation
                                            </div>
                                            <div class="col-md-10 col-lg-10">
                                                <select multiple class="col-md-4 col-lg-4 p-2 col-12" id="designationId"
                                                    name="designationId[]">
                                                    <!-- <option value="">Please Select</option>    -->
                                                    <?php   if(isset($designation)){
                                                          foreach($designation as $row){ ?>
                                                    <option <?php  
                                                                    if(isset($activitydetails)){ 
                                                                        if($activitydetails){
                                                                            $s=explode(",",$activitydetails['designationIds']);
                                                                                if(in_array($row['designationId'],$s)){
                                                                                    echo 'selected';
                                                                                }
                                                                        } }else{
                                                                            echo set_select('designationId[]',$row['designationId']);
                                                                    }
                                                                    ?> value="<?= $row['designationId'];?>">
                                                        <?= $row['committeeName'].'-'. $row['designationName'];?>
                                                    </option>
                                                    <?php } }?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </span>
                                <div class="my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Upload Type<span style="color: red;"><b>*</b></span>
                                        </div>
                                        <div class="col-md-10">
                                            <div class="col-md-12 py-1">
                                                <div class="row">
                                                    <div class="col-md-4 col-lg-2 form-check text-center">
                                                        <input class="form-check-input" <?php 
                                            if(isset($activitydetails)){
                                            if($activitydetails['UploadType']=="Image"){
                                                echo 'checked';
                                            } }else{
                                                echo  set_radio('UploadType', 'Image');
                                            }
                                            ?> type="radio" name="UploadType" value="Image" id="UploadType"
                                                            onclick="handleClick(this.value);" checked>
                                                        <label class="form-check-label" for="flexRadioDefault1">
                                                            Image
                                                        </label>
                                                    </div>
                                                    <div class="col-md-4 col-lg-2 form-check">
                                                        <input class="form-check-input" type="radio" <?php 
                                            if(isset($activitydetails)){
                                            if($activitydetails['UploadType']=="Audio"){
                                                echo 'checked';
                                            } }else{
                                                echo  set_radio('UploadType', 'Audio');
                                            }
                                            ?> name="UploadType" value="Audio" id="UploadType"
                                                            onclick="handleClick(this.value);">
                                                        <label class="form-check-label" for="flexRadioDefault2">
                                                            Audio
                                                        </label>
                                                    </div>
                                                    <div class="col-md-4 col-lg-2 form-check">
                                                        <input class="form-check-input" type="radio" <?php 
                                            if(isset($activitydetails)){
                                            if($activitydetails['UploadType']=="Video"){
                                                echo 'checked';
                                            } }else{
                                                echo  set_radio('UploadType', 'Video');
                                            }
                                            ?> name="UploadType" onclick="handleClick(this.value);" value="Video"
                                                            id="UploadType">
                                                        <label class="form-check-label" for="flexRadioDefault3">
                                                            Video
                                                        </label>
                                                    </div>
                                                    <div class="col-lg-4 col-md-8 form-check">
                                                        <input class="form-check-input" type="radio" <?php 
                                            if(isset($activitydetails)){
                                            if($activitydetails['UploadType']=="Documents/Posters"){
                                                echo 'checked';
                                            } }else{
                                                echo  set_radio('UploadType', 'Documents/Posters');
                                            }
                                            ?> name="UploadType" onclick="handleClick(this.value);"
                                                            value="Documents/Posters" id="UploadType">
                                                        <label class="form-check-label" for="flexRadioDefault4">
                                                            Documents/Posters
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 py-1">
                                                <input type="file" onChange="validate(this.value)" required
                                                    class="form-control participation col-md-8 p-2 col-12"
                                                    accept=".jpg,.jpeg" id="file" name="file">
                                                <span style="color:red" id="error"></span>
                                                <?php if(isset($activitydetails)){ ?>
                                                <input type="hidden" name="ActivityId"
                                                    value="<?php echo $activitydetails['ActivityId'];?>">
                                                <input type="hidden" name="old_img"
                                                    value="<?php echo $activitydetails['UploadResource'];?>">
                                                <?php if($activitydetails['UploadType']=="Image"){ ?>
                                                <img style="width:220px; height:180px; padding:10px 0 10px 0;"
                                                    src="<?= $file_path ?>" alt="Reference file" width="400"
                                                    height="400">
                                                <?php }elseif($activitydetails['UploadType']=="Video"){ ?>
                                                <video width="100" height="100" controls>
                                                    <source src="<?= $file_path ?>" type="video/mp4">
                                                    Your browser does not support the video tag.
                                                </video>
                                                <?php }elseif($activitydetails['UploadType']=="Audio"){ ?>
                                                <audio controls>
                                                    <source src="horse.ogg" type="audio/ogg">
                                                    <source src="<?= $file_path ?>" type="audio/mpeg">
                                                    Your browser does not support the audio element.
                                                </audio>
                                                <?php }elseif($activitydetails['UploadType']=="Documents/Posters"){ ?>

                                                <!-- <iframe style="padding:10px 0px 10px 0px;"  src="<?= $file_path ?>" width="90%" height="500px"></iframe> -->
                                                <?php 
                                            $path=base_url().'/uploads/pragram_activity_files/'.$activitydetails["UploadResource"];
                                            $file = new SplFileInfo($path);
                                             $extension  = $file->getExtension(); 
                                             if($extension=="pdf"){ ?>
                                                <iframe style="padding:10px 0px 10px 0px;" src="<?= $file_path ?>"
                                                    width="90%" height="500px"></iframe>
                                                <?php }else{ ?>
                                                <a
                                                    href="<?= $file_path ?>"><?=$activitydetails['UploadResource'].'- Download ' ?></a>
                                                <?php }  
                                             // echo  $extension = pathinfo($path, PATHINFO_EXTENSION);
                                            ?>

                                                <?php }else{ ?>
                                                <iframe style="padding:10px 0px 10px 0px;" src="<?= $file_path ?>"
                                                    width="90%" height="500px"></iframe>
                                                <?php }?>

                                                <?php } ?>
                                            </div>
                                            <!-- <iframe src="<?= base_url()?>/uploads/pragram_activity_files/Document A to B tables.docx??url=&embedded=true" width="90%" height="500px"></iframe> -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="container-fluid">
                                <div class="col-md-12">
                                    <h4>Program Metrics Measurements(SELECT CHECKBOXES if applicable)</h4>
                                </div>

                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Media Coverage
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="MediaCoverage" name="MediaCoverage" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['MediaCoverage'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("MediaCoverage", "Yes");
                                }
                                ?> value="Yes" class="MediaCoverage">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Banner Displayed
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="BannerDisplayed"
                                                    name="BannerDisplayed" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['BannerDisplayed'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("BannerDisplayed", "Yes");
                                }
                                ?> value="Yes" class="BannerDisplayed">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Parliament President Participated
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="ParliamentPresidentParticipated"
                                                    name="ParliamentPresidentParticipated" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['ParliamentPresidentParticipated'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("ParliamentPresidentParticipated", "Yes");
                                }
                                ?> value="Yes" class="BannerDisplayed">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            MLA/Incharge Participation
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="MlaInchargeParticipation"
                                                    name="MlaInchargeParticipation" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['MlaInchargeParticipation'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("MlaInchargeParticipation", "Yes");
                                }
                                ?> value="Yes" class="MlaInchargeParticipation">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Constituency Leaders Participated
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="ConstituencyLeadersParticipated"
                                                    name="ConstituencyLeadersParticipated" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['ConstituencyLeadersParticipated'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("ConstituencyLeadersParticipated", "Yes");
                                }
                                ?> value="Yes" class="ConstituencyLeadersParticipated">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Whatsapp Images/Videos
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto">
                                                <input type="checkbox" required id="WhatsappImagesVideos"
                                                    name="WhatsappImagesVideos" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['WhatsappImagesVideos'] == "Yes"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("WhatsappImagesVideos", "Yes");
                                }
                                ?> value="Yes" class="WhatsappImagesVideos">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!--
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Media Coverage
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="InMediaCovarage" value="<?= (isset($activitydetails))?$activitydetails['InMediaCovarage']:set_value('InMediaCovarage'); ?>"   name="InMediaCovarage" class="activityName form-control col-md-4 p-2 col-12 ">
                            <div class=" p-2 my-auto">
                                <input type="checkbox" id="MediaCovarage"  name="MediaCovarage" <?php
                                if(isset($activitydetails)){
                                    if($activitydetails['MediaCovarage'] == "1"){
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("MediaCovarage", "1");
                                }
                                ?>   value="1" class="MediaCovarage">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Material Usage and Format
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="InMaterialUsageFormat" value="<?= (isset($activitydetails))?$activitydetails['InMaterialUsageFormat']:set_value('InMaterialUsageFormat'); ?>" name="InMaterialUsageFormat" class="muf form-control col-md-4 p-2 col-12">
                            <div class="p-2 my-auto">
                                <input type="checkbox" id="MaterialUsageFormat" name="MaterialUsageFormat"  
                                <?php if(isset($activitydetails)){
                                    if($activitydetails['MaterialUsageFormat'] == "1"){ 
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("MaterialUsageFormat", "1");
                                }
                                ?> 
                                value="1" class="muf_cb checkbox">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Public Response
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="InPublicResponse" value="<?= (isset($activitydetails))?$activitydetails['InPublicResponse']:set_value('InPublicResponse'); ?>" name="InPublicResponse" class="form-control publicResponse col-md-4 p-2 col-12">
                            <div class=" p-2 my-auto">
                                <input type="checkbox" id="PublicResponse" name="PublicResponse"  
                                <?php if(isset($activitydetails)){
                                    if($activitydetails['PublicResponse'] == "1"){ 
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("PublicResponse", "1");
                                 }
                                ?> 
                                value="1" class="publicResponse_cb checkbox">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Any Special Activities
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="InAnySpecialActivities" name="InAnySpecialActivities" value="<?= (isset($activitydetails))?$activitydetails['InAnySpecialActivities']:set_value('InAnySpecialActivities'); ?>"   class="form-control spclActivity col-md-4 p-2 col-12">
                            <div class=" p-2 my-auto">
                                <input type="checkbox" id="AnySpecialActivities" name="AnySpecialActivities" value="1"
                                <?php if(isset($activitydetails)){
                                    if($activitydetails['AnySpecialActivities'] == "1"){ 
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("AnySpecialActivities", "1");
                                }
                                ?>   class="spclActivity_cb checkbox">
                            </div>
                        </div>
                    </div>
                </div>
      
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Social Media Coverage
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="SocialMediaCoverage" name="SocialMediaCoverage" value="<?= (isset($activitydetails))?$activitydetails['SocialMediaCoverage']:set_value('SocialMediaCoverage'); ?>"  class="form-control socialMedia col-md-4 p-2 col-12">
                            <div class=" p-2 my-auto">
                                <input type="checkbox" id="InSocialMediaCoverage" name="InSocialMediaCoverage" value="1" 
                                <?php if(isset($activitydetails)){
                                    if($activitydetails['InSocialMediaCoverage'] == "1"){ 
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("InSocialMediaCoverage", "1");
                                }
                                ?> class="socialMedia_cb checkbox">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Leader/Committee Participation
                        </div>
                        <div class="col-md-10 d-flex">
                            <input type="text" id="InLeadORComm_Participation" value="<?= (isset($activitydetails))?$activitydetails['InLeadORComm_Participation']:set_value('InLeadORComm_Participation'); ?>" name="InLeadORComm_Participation" class="form-control leaderParticipation col-md-4 p-2 col-12">
                            <div class="p-2 my-auto">
                                <input type="checkbox" id="LeadORCommittee_Participation" name="LeadORCommittee_Participation" 
                                <?php if(isset($activitydetails)){
                                    if($activitydetails['LeadORCommittee_Participation'] == "1"){ 
                                        echo 'checked';
                                    }
                                }else{
                                    echo set_checkbox("LeadORCommittee_Participation", "1");
                                }
                                ?>
                                value="1"  class="leaderParticipation_cb checkbox">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 my-3">
                    <div class="row">
                        <div class="col-md-2 align-self-center fw-bolder">
                            Social Listing from Ground
                        </div>
                        <div class="col-md-10">
                            <textarea id="SocialListingFromGround" name="SocialListingFromGround" class="form-control links col-md-8 p-2 col-12"
                                placeholder="Any Uselful references like songs etc." rows="4" cols="50"><?= (isset($activitydetails))?$activitydetails['SocialListingFromGround']:set_value('SocialListingFromGround'); ?> </textarea>
                        </div>
                    </div>
                </div> -->
                            </div>
                            <div class="container-fluid">
                                <div class="col-md-12">
                                    <h4>Door To Door Campaign</h4>
                                    <hr>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Flyers Distribution
                                        </div>
                                        <div class="col-md-6 d-flex">
                                            <div class=" p-2 my-auto col-md-12">
                                                <div class="media-check my-auto col-md-1 px-0">
                                                    <input type="checkbox" id="flyers_distribution"
                                                        name="flyers_distribution" <?php
                                    if(isset($activitydetails)){
                                        if($activitydetails['flyers_distribution'] == "Yes"){
                                            echo 'checked';
                                        }
                                    }else{
                                        echo set_checkbox("flyers_distribution", "Yes");
                                    }
                                    ?> value="Yes" class="MediaCoverage">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2 align-self-center fw-bolder">
                                            Number Of Householders
                                        </div>
                                        <div class="col-md-10 d-flex">
                                            <div class=" p-2 my-auto col-md-12">
                                                <div class="  my-auto col-md-6 px-0">
                                                    <input type="number" min='0' name="number_of_householders"
                                                        id="number_of_householders"
                                                        value="<?= (isset($activitydetails))?$activitydetails['number_of_householders']:set_value('number_of_householders'); ?>"
                                                        class="form-control col-md-3">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if(isset($compaign_questions)){ foreach($compaign_questions as $row){ ?>
                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-12 align-self-center fw-bolder">
                                            Question: <?php echo $row['question']; ?>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="row">
                                                <div class="col-md-2 col-lg-1">Options:</div>
                                                <?php foreach($row['options'] as $r){  ?>
                                                <div class="col-md-2 align-items-center">
                                                    <input type="radio" id="html" name="fav_language"
                                                        value="<?php echo $r['option_name']; ?>">
                                                      <label for="html"><?php echo $r['option_name']; ?></label><br>
                                                </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } } ?>

                                <div class="col-md-12 my-3">
                                    <div class="row">
                                        <div class="col-md-2"> </div>

                                        <div class="col-md-10">
                                            <div class="p-2">
                                                <button type="button" name="add" id="add"
                                                    class="btn btn-success px-3">Add
                                                    Question</button></td>
                                            </div>
                                            <!-- <table class="table table-bordered" id="dynamic_field">   -->
                                            <div class="dynamic" id="dynamic_field"></div>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php if(isset($view)){ ?>

                            <?php }else{?>
                            <div class="button my-3 mb-5">
                                <button class="btn btn-warning ">Submit</button>
                            </div>
                            <?php }?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>







</div>
<?php if(isset($view)){ 
    ?>
<script>
$(document).ready(function() {
    $("#formId").on("submit", function() {
        $("#pageloader").fadeIn();
    }); //submit
}); //document ready

var form = document.getElementById("formId");
var allElements = form.elements;
for (var i = 0, l = allElements.length; i < l; ++i) {
    // allElements[i].readOnly = true; 
    allElements[i].disabled = true;
}
</script>
<?php }?>

<?php 
          if(isset($activitydetails)){  if($activitydetails['designatedMember'] == "No"){  ?>
<script>
$('#ShowHide').hide();
</script>
<?php  } }
        
    ?>
<?php if(isset($activitydetails)){ if(empty($activitydetails['affiliatedCommitteeId'])){ ?>
<script>
$('#designationOrAffiliated_Committees').hide();
</script>
<?php } } ?>
<script>
$('#committeeNameIdss').multiSelect();
$('#committeeNameId').multiselect({
    nonSelectedText: 'Select Committee Name',
    buttonWidth: '400px'
});
$('#designationId').multiselect({
    nonSelectedText: 'Please Select Designations',
    buttonWidth: '400px',
});
$('#affiliatedCommitteeId').multiselect({
    nonSelectedText: 'Please Select Affiliated Committee',
    buttonWidth: '400px',
});


//get groups
$(document).ready(function() {
    //get Custom fields
    var i = 1;
    $('#add').click(function() {
        $('#dynamic_field').append('<div class="col-md-12 my-3 p-2" id="row' + i +
            '"><div class="row"><div class="col-md-4"><input type="text" name="name[]" required placeholder="Question" class="col-md-12 form-control name_list " /></div><div class="col-md-2 col-lg-1"><button type="button" name="remove" id="' +
            i +
            '" class="btn btn-danger btn_remove">X</button></div><div class="col-md-4"><button type="button" name="remove" id="' +
            i + '" class="btn btn-info btn_option">Add Option</button></div><div id="otpion' + i +
            '"></div></div></div>');
        i++;
    });

    $('.btn_option').click(function() {
        var button_id = $(this).attr("id");

        $('#otpion' + button_id + '').append('<div id="row' + i +
            '"><input type="text" name="name[]" placeholder="Enter your Name" class="form-control name_list" /><button type="button" name="remove" id="' +
            i + '" class="btn btn-danger btn_remove">X</button></div>');
    });
    var x = 1;
    $(document).on('click', '.btn_option', function() {

        var button_id = $(this).attr("id");
        // $('#otpion'+button_id+'')
        $('#otpion' + button_id + '').append('<div class="col-md-12 py-2" id="option' + x +
            '"><div class="row"><div class="col-md-4"><input type="text" required name="option' +
            button_id +
            '[]" placeholder="Option" class="col-md-12 form-control name_list opt' + button_id +
            '" /></div><div class="col-md-2"><button type="button" name="remove" id="' + x +
            '" class="btn btn-danger btn_option_remove">X</button></div></div></div>');

        x++;
    });

    $(document).on('click', '.btn_remove', function() {
        var button_id = $(this).attr("id");
        $('#row' + button_id + '').remove();
    });

    $(document).on('click', '.btn_option_remove', function() {
        var button_id = $(this).attr("id");
        $('#option' + button_id + '').remove();
    });

    //get groups
    $('#designatedMember').change(function() {
        var designatedMember = $('#designatedMember').val();
        var action = 'get_designatedMember';
        if (designatedMember != '') {
            //  $('#committeeNameId').multiselect('rebuild');
            $.ajax({
                url: "<?php echo base_url('/get-ajax-roles'); ?>",
                method: "GET",
                data: {
                    designatedMember: designatedMember,
                    action: action
                },
                dataType: "JSON",
                success: function(data) {
                    //var html = '<option value="">Please Select</option>';  
                    var html = '';
                    for (var count = 0; count < data.length; count++) {
                        html += '<option value="' + data[count].committeeNameId + '">' +
                            data[count].committeeName + '</option>';
                    }
                    $('#committeeNameId').html(html);
                    $('#committeeNameId').multiselect('rebuild');
                    // $('#committeeNameId').multiselect({ 
                    //         nonSelectedText: 'Select Committee Name',
                    //         buttonWidth:'400px'
                    // });
                }
            });
        } else {
            $('#committeeNameId').val('');
        }
    });

    $('#committeeNameId').change(function() {

        var committeeNameId = $('#committeeNameId').val();
        var committeeNameIds = $('#committeeNameId').val();
        var designatedMember = $('#designatedMember').val();
        if (designatedMember == "Yes") {
            $('#ShowHide').show();
            $('#committeeNameId').attr('required', 'required');
            $('#designatedMember').attr('required', 'required');
            $('#committeeTypeId').attr('required', 'required');
            var action = 'get_committeeTypeId';
            if (committeeNameId != '') {
                //alert(committeeNameId);

                $.ajax({
                    url: "<?php echo base_url('/get-ajax-roles'); ?>",
                    method: "GET",
                    data: {
                        committeeNameId: committeeNameId,
                        action: action
                    },
                    dataType: "JSON",
                    success: function(data) {

                        // var html = '<option value="">Please Select</option>'; 
                        var html = '<option value="">Please Select</option>';
                        html += '<option value="Main">Main</option>';
                        html += '<option value="Affiliated">Affiliated</option>';
                        $('#committeeTypeId').html(html);

                        //   $('#committeeTypeId').html(html);
                        //  $('#committeeTypeId').multiselect('rebuild');

                        //getDesgniations(committeeNameIds); 
                    }
                });
            } else {
                $('#committeeTypeId').val('');
            }
        } else {
            $('#committeeTypeId').removeAttr('required');
            $('#designationId').removeAttr('required');
            $('#affiliatedCommitteeId').removeAttr('required');

            $('#ShowHide').hide();
        }

    });

    //Commitee Type 

    $('#committeeTypeId').change(function() {
        var committeeNameId = $('#committeeNameId').val();
        var committeeNameIds = $('#committeeNameId').val();
        var committeeTypeName = $('#committeeTypeId').val();

        var action = 'get_affiliatedCommitteeIdForSmTask';
        if (committeeTypeName != '') {
            if (committeeTypeName == "Affiliated") {
                $.ajax({
                    url: "<?php echo base_url('/get-ajax-roles'); ?>",
                    method: "GET",
                    data: {
                        committeeNameId: committeeNameId,
                        committeeTypeName: committeeTypeName,
                        action: action
                    },
                    dataType: "JSON",
                    success: function(data) {
                        var count = Object.keys(data).length;
                        if (count) {

                            $('#designationOrAffiliated_Committees').show();
                            $("#affiliatedCommitteeId").val();
                            var html =
                                '<div class="col-md-4 col-lg-2 align-self-center fw-bolder">Affiliated Committees</div><div class="col-md-8 col-lg-10"><select  multiple class="col-md-12 col-lg-4 p-2 col-12" id="affiliatedCommitteeId"  name="affiliatedCommitteeId[]"  onchange="getValue(this);">';
                            // var html+= '<option value="">Please Select</option>';   
                            for (var count = 0; count < data.length; count++) {

                                html += '<option value="' + data[count].aff_id + '">' +
                                    data[count].committeeName + '-' + data[count]
                                    .committeeTypeName + '-' + data[count]
                                    .affiliatedCommitteeName + '</option>';

                            }
                            html += '</select></div>';

                            $('#affiliatedCommitteeId').attr('required', 'required');
                            $('#designationOrAffiliated_Committees').html(html);
                            $('#affiliatedCommitteeId').multiselect('rebuild');

                        } else {

                        }
                    }
                });
            } else {
                $('#affiliatedCommitteeId').val(false);
                $('#affiliatedCommitteeId').removeAttr('required');

                $('#designationOrAffiliated_Committees').hide();
                getDesgniations(committeeNameIds);
            }

        } else {
            $('#designationOrAffiliated_Committees').val('');
        }
        //  } 

    });

    function getDesgniations(committeeNameIds) {
        var action = 'get_designationId';
        if (committeeNameIds != '') {
            $.ajax({
                url: "<?php echo base_url('/get-ajax-roles'); ?>",
                method: "GET",
                data: {
                    committeeNameId: committeeNameIds,
                    action: action
                },
                dataType: "JSON",
                success: function(data) {
                    // var html= '<option value="">Please Select</option>'; 
                    var html = '';
                    for (var count = 0; count < data.length; count++) {

                        html += '<option value="' + data[count].designationId + '">' + data[count]
                            .committeeName + '-' + data[count].designationName + '</option>';

                    }
                    //  html +='</select></div></span>';
                    $('#designationId').html(html);
                    $('#designationId').multiselect('rebuild');
                }
            });
        } else {
            $('#designationId').val('');
        }
    }
});

function validate(file) {
    var ext = file.split(".");
    ext = ext[ext.length - 1].toLowerCase();
    var value = $("input[name='UploadType']:checked").val();
    if (value == "Documents/Posters") {
        acceptTypeValue = ["doc", "pdf", "docx"];
    } else if (value == "Image") {
        acceptTypeValue = ["jpg", "jpeg", "png"];
    } else if (value == "Audio") {
        acceptTypeValue = ["mp3"];
    } else {
        acceptTypeValue = ["mp4"];
    }
    var arrayExtensions = acceptTypeValue;
    if (arrayExtensions.lastIndexOf(ext) == -1) {
        $("#file").val("");
        var htmlData = "Please Give Valid Format File";
        $("#error").show();
        $('#error').html(htmlData);
    } else {
        $("#error").hide();
    }

}


function handleClick(value) {
    // var acceptType=".pdf,.doc";
    if (value == "Documents/Posters") {
        acceptType = ".doc,.pdf,.docx";
        acceptTypeValue = ["doc", "pdf", "docx"];
    } else if (value == "Image") {
        acceptType = ".jpg,.jpeg,.png";
        acceptTypeValue = ["jpg", "jpeg", "png"];
    } else if (value == "Audio") {
        acceptType = ".mp3";
        acceptTypeValue = ["mp3"];
    } else {
        acceptType = "video/mp4,video/x-m4v,video/*";
        acceptTypeValue = ["mp4"];
    }
    var filename = document.getElementById('file');
    //alert(value);
    //accept=".jpg,.jpeg" 
    var att = document.createAttribute("accept");
    att.value = acceptType;
    filename.setAttributeNode(att);
}

function getValue(id) {
    var action = 'get_AffiliateddesignationId';
    //    var affiliatedCommitteeId = document.getElementById("affiliatedCommitteeId").value;
    var affiliatedCommitteeId = $('#affiliatedCommitteeId').val();
    //alert(affiliatedCommitteeId);
    if (affiliatedCommitteeId != '') {

        $.ajax({
            url: "<?php echo base_url('/get-ajax-roles'); ?>",
            method: "GET",
            data: {
                affiliatedCommitteeId: affiliatedCommitteeId,
                action: action
            },
            dataType: "JSON",
            success: function(data) {
                //  console.log(data);
                var designationId = data.length;
                if (designationId > 0) {
                    // var html= '<option value="">Please Select</option>';   
                    var html = '';
                    for (var count = 0; count < data.length; count++) {

                        html += '<option value="' + data[count].designationId + '">' + data[count]
                            .committeeName + '-' + data[count].affiliatedCommitteeName + '-' + data[count]
                            .designationName + '</option>';

                    }
                    //  html +='</select></div></span>';
                    $('#designationId').html(html);
                    $('#designationId').multiselect('rebuild');
                } else {
                    var html = '<option value="">There Is No Designations Here</option>';
                    $('#designationId').html(html);
                    $('#designationId').multiselect('rebuild');
                }
            }
        });
    } else {
        $('#affiliatedCommitteeId').val('');
    }
}
</script>
<?= $this->endSection("content");?>