<?php  

namespace App\Controllers;
header('Access-Control-Allow-Origin: *'); //for allow any domain, insecure          
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE'); //method allowed 
header('Access-Control-Allow-Headers: *'); //for allow any headers, insecure
 

header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
use Aws\S3\S3Client; 
use App\Libraries\Hash;
//use App\Controllers\BaseController;
use App\Models\ApiModel;
use App\Models\Admin_model;
use CodeIgniter\RESTful\ResourceController;
use Exception;
use \Firebase\JWT\JWT;


class Api extends ResourceController
{
    private $ApiModel;
    private $AdminModel;
    public function __construct(){  

        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $method = $_SERVER['REQUEST_METHOD'];
        if ($method == "OPTIONS") {
            die();
        }

		$db = \Config\Database::connect();
		$session = \CodeIgniter\Config\Services::session();
		date_default_timezone_set("Asia/Calcutta");
		helper(['url','form','Form']);  
		$this->ApiModel=new ApiModel();
		$this->AdminModel=new Admin_model();
	
	}
    public function index()
    {
        //
    }
    private function getKey()
    {
        return "my_application_secret";
    }

    private function getDomainName(){
        return "http://172.105.53.205/yellow";
    }
    
    public function register()
    {         
        $rules = [
            "LastName" => "required",
            "FirstName" => "required",
            "Email" => "required|valid_email|is_unique[users.email]|min_length[6]",
            "Mobile" => "required|is_unique[users.Mobile]",
            "Password"=>"required",
            'ParliamentId'=>'required',
            'ConstituencyId'=>'required',
            'MandalId'=>'required',
            'DOB'=>'required',
            'Gender'=>'required'
        ];
        $messages = [
            "LastName" => [
                "required" => "LastName is required"
            ],
            "FirstName" => [
                "required" => "FirstName is required"
            ],
            "Email" => [
                "required" => "Email required",
                "valid_email" => "Email address is not in format"
            ],
            "Mobile" => [
                "required" => "Phone Number is required"
            ],
            "Password" => [
                "required" => "Password is required"
            ],
            "ParliamentId" => [
                "required" => "Parliament is required"
            ],
            "ConstituencyId" => [
                "required" => "Constituency is required"
            ]
        ];

        if (!$this->validate($rules, $messages)) { 
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
        } else {  
            $table_data = [
                "LastName" => $this->request->getVar("LastName",FILTER_SANITIZE_STRING),
                "DisplayName" => $this->request->getVar("DisplayName",FILTER_SANITIZE_STRING),
                "FirstName" => $this->request->getVar("FirstName",FILTER_SANITIZE_STRING),
                "Email" => $this->request->getVar("Email",FILTER_SANITIZE_STRING),
                "Mobile" => $this->request->getVar("Mobile",FILTER_SANITIZE_NUMBER_INT),
                "ParliamentId" => $this->request->getVar("ParliamentId",FILTER_SANITIZE_NUMBER_INT),
                "ConstituencyId" => $this->request->getVar("ConstituencyId",FILTER_SANITIZE_NUMBER_INT),
                "MandalId" => $this->request->getVar("MandalId",FILTER_SANITIZE_NUMBER_INT),
                "Password" => password_hash($this->request->getVar("Password"), PASSWORD_DEFAULT),
                'DOB'=>$this->request->getVar("DOB"),
                'Gender'=>$this->request->getVar("Gender")
            ];
                $table="users";
            if ($this->ApiModel->insert_record($table,$table_data)) {
                $response = [
                    'status' => 200,
                    "error" => false,
                    'messages' => 'Successfully, user has been registered',
                    'data' => []
                ];
            } else {
                $response = [
                    'status' => 500,
                    "error" => true,
                    'messages' => 'Failed to create user',
                    'data' => []
                ];
            }
        }
        return $this->respondCreated($response);
    }
    //login
    public function login(){ 
        $rules = [
            "Mobile" => "required",
            "Password" => "required",
        ];
        $messages = [
            "Mobile" => [
                "required" => "Email required"
            ],
            "Password" => [
                "required" => "Password is required"
            ],
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            return $this->respondCreated($response);
            
        }else{
            //$userModel = new UserModel();

           // $userdata = $userModel->where("email", $this->request->getVar("email"))->first();
            $table="users";
            $where_parameter="Mobile";
             $where_id=$this->request->getVar("Mobile");
          
            $userdata=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
            // 
            if (!empty($userdata)) { 
                $check_password=Hash::check($this->request->getVar("Password"), $userdata['Password']);
                if ($check_password) {
                    if($userdata['MobileVerified'] == "1"){ 
                        if($userdata['Status'] == "Approved"){                            
                                $userdata=$this->ApiModel->getRowTableByMobileId($table,$where_parameter,$where_id);
                                $key = $this->getKey();
                                $iat = time(); // current timestamp value
                                $nbf = $iat + 10;
                                $exp = $iat + 36000000;

                                $payload = array(
                                    "iss" =>  $this->getDomainName(),
                                    "aud" => "The_Aud",
                                    "iat" => $iat, // issued at
                                    "nbf" => $nbf, //not before in seconds
                                    "exp" => $exp, // expire time in seconds
                                    "data" => $userdata,
                                );

                                $token = JWT::encode($payload, $key);

                                $response = [
                                    'status' => 200,
                                    'error' => false,
                                    'messages' => 'User logged In successfully',
                                    'data' => [
                                        'userdata'=>$userdata, 
                                        'token' => $token
                                    ]
                                ];
                                return $this->respondCreated($response);
                        }else{
                            /* 
                                $userdata=$this->ApiModel->getRowTableByMobileId($table,$where_parameter,$where_id);
                                $key = $this->getKey();
                                $iat = time(); // current timestamp value
                                $nbf = $iat + 10;
                                $exp = $iat + 36000000;

                                $payload = array(
                                    "iss" =>  $this->getDomainName(),
                                    "aud" => "The_Aud",
                                    "iat" => $iat, // issued at
                                    "nbf" => $nbf, //not before in seconds
                                    "exp" => $exp, // expire time in seconds
                                    "data" => $userdata,
                                );

                                $token = JWT::encode($payload, $key);
 */
                                $response = [
                                    'status' => 200,
                                    'error' => false,
                                    'messages' => 'Please Wait For Admin Approve',
                                    'data' => [
                                        'userdata'=>["Status"=>"Pending"],  
                                        "Status"=>"Pending",
                                        "MembershipId"=>$userdata['MembershipId']
                                    ]
                                ];
                                return $this->respondCreated($response);
                        }
                    }else{ 
                        $response = [
                            'status' => 500,
                            'error' => true,
                            'messages' => 'Please Wait For Admin Approve',
                            'data' => [
                                'userdata'=>["Status"=>"Pending"],  
                                "Status"=>"Pending",
                                "MembershipId"=>$userdata['MembershipId']
                                ]
                        ];
                        return $this->respondCreated($response);
                    } 
                    
                } else{
                    $response = [
                        'status' => 500,
                        'error' => true,
                        'messages' => 'Incorrect details',
                        'data' => [
                            'userdata'=>["Status"=>500],
                        ]
                    ];
                    return $this->respondCreated($response);
                }
            } else { 
                $response = [
                    'status' => 500,
                    'error' => true,
                    'messages' => 'User not found',
                    'data' => [
                        'userdata'=>["Status"=>500],
                    ]
                ];
                return $this->respondCreated($response);
            }
        }
    }
    public function otpLogin(){ 
        $rules = [
            "Mobile" => "required",
            "OTP" => "required",
        ];
        $messages = [
            "Mobile" => [
                "required" => "Mobile required"
            ],
            "OTP" => [
                "required" => "OTP is required"
            ],
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            return $this->respondCreated($response);
            
        }else{
            //$userModel = new UserModel();

           // $userdata = $userModel->where("email", $this->request->getVar("email"))->first();
            $table="users";
            $where_parameter="Mobile";
            $where_id=$this->request->getVar("Mobile");
            $userdata=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
            if (!empty($userdata)) { 
                $this->verifiedOtp();

              //  $check_password=Hash::check($this->request->getVar("Password"), $userdata['Password']);
                 $otp=$this->request->getVar("OTP");
                if ($otp==$userdata['OTP']) {
                    if($userdata['MobileVerified'] == "1"){
                        $key = $this->getKey();
                        $iat = time(); // current timestamp value
                        $nbf = $iat + 10;
                        $exp = $iat + 3600000;
    
                        $payload = array(
                            "iss" => "http://172.105.53.205/yellow",
                            "aud" => "The_Aud",
                            "iat" => $iat, // issued at
                            "nbf" => $nbf, //not before in seconds
                            "exp" => $exp, // expire time in seconds
                        );
    
                        $token = JWT::encode($payload, $key);
    
                        $response = [
                            'status' => 200,
                            'error' => false,
                            'messages' => 'User logged In successfully',
                            'data' => [
                                'userdata'=>$userdata, 
                                'token' => $token
                            ]
                        ];
                        return $this->respondCreated($response);
                    }else{
                        $response = [
                            'status' => 200,
                            'error' => false,
                            'messages' => 'OTP Verified Successfully, Please Wait For Admin Approvals',
                            'data' => [
                                'userdata'=>["status"=>"Pending"],  
                                "status"=>"Pending"]
                        ];
                        return $this->respondCreated($response);
                    }

                   
                } else{ 
                    $response = [
                        'status' => 500,
                        'error' => true,
                        'messages' => 'Incorrect OTP details',
                        'data' => []
                    ];
                    return $this->respondCreated($response);
                }
            } else {
                $response = [
                    'status' => 500,
                    'error' => true,
                    'messages' => 'User not found',
                    'data' => []
                ];
                return $this->respondCreated($response);
            }
        }
    } 
    public function profile()
    {  
        $rules = [
            "u_id" => "required"
        ];
        $messages = [
            "u_id" => [
                "required" => "User Id required"
            ]
        ];

        if (!$this->validate($rules, $messages)){
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            return $this->respondCreated($response);
            
        }else{
      
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();       
            // $token = $authHeader;
        
            try{
               // $decoded = JWT::decode($token, $key, array("HS256"));
                //if ($decoded){
                    $u_id=$this->request->getVar("u_id"); 
                   // $where_parameter='u_id';
                    //$where_id=$u_id;
                   // $profile=$this->AdminModel->getRowTableById('users',$where_parameter,$where_id);
     
                    $profile=$this->AdminModel->getProfileDetails($u_id);

                    //$profile=$this->AdminModel->getRowTableByUserId('users',$where_parameter,$where_id);

                    if($profile['ProfileImage']){
                        $profile['img_path']=base_url()."/uploads/user_profile/".$profile['ProfileImage'];
                    }else{
                        $profile['img_path']=""; 
                    }
                  
                    $response = [
                        'status' => 200, 
                        'error' => false,
                        'messages' => 'User details',
                        'data' => $profile
                    ];
                    return $this->respondCreated($response);
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
                return $this->respondCreated($response);
            }
        }
    }
    //get matser data api
    public function masterData(){     
        //prliment data
        $parameters=array('ParliamentID','ParliamentName','IsActive','1');
        $parliament=$this->AdminModel->getQueryFromTableAsc('parliament',$parameters,'ParliamentName');
        if($parliament){
            //constituencies
            $parameters=array('ConstituencyID','ConstituencyName','ParliamentID','IsActive','1');
            $constituencies=$this->AdminModel->getQueryFromTableAsc('constituency',$parameters,'ConstituencyName');
            //mandals
            $parameters=array('mandal_id','mandal_name','constituency_id','IsActive','1');
            $mandals=$this->AdminModel->getQueryFromTableAsc('mandals',$parameters,'mandal_name');
            //get villages
            $parameters=array('VillageId','mandal_id','villageName','IsActive','1');
            $villages=$this->AdminModel->getQueryFromTableAsc('villages',$parameters,'villageName');
            
            //commite details
            $parameters=array('CommitteeID','CName','IsActive','1');
            $committee=$this->AdminModel->getQueryFromTableAsc('committee',$parameters,'CName');

            $response = [ 
                'status' => 200,
                'error' => false,
                'messages' => 'Master Data Details',
                'data' => [
                    'parliaments' => $parliament,
                    'constituencies'=>$constituencies,
                    'mandals'=>$mandals,
                    'committee'=>$committee,
                    'villages'=>$villages
                ]
            ];
        }else{
            $response = [
                'status' => 500,
                "error" => true,
                'messages' => 'Failed to create user',
                'data' => []
            ];
        }
        
        return $this->respondCreated($response);
    }

    public function test()
    {        
        $rules = [
            "LastName" => "required",
            "FirstName" => "required",
            "Mobile" => "required|is_unique[users.Mobile]",
            "Password"=>"required",
            'ParliamentId'=>'required',
            'ConstituencyId'=>'required' 
        ];
        $messages = [
            "LastName" => [
                "required" => "LastName is required"
            ],
            "FirstName" => [
                "required" => "FirstName is required"
            ],
            "Mobile" => [
                "required" => "Phone Number is required"
            ],
            "Password" => [
                "required" => "Password is required"
            ],
            "ParliamentId" => [
                "required" => "Parliament is required"
            ],
            "ConstituencyId" => [
                "required" => "Constituency is required"
            ]
        ];
        if (!$this->validate($rules, $messages)) { 
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
        } else { 
            $otp = rand(1231,7879); 
            $table_data = [
                "LastName" => $this->request->getVar("LastName"),
                "DisplayName" => $this->request->getVar("DisplayName",FILTER_SANITIZE_STRING),
                "FirstName" => $this->request->getVar("FirstName"),
                "Email" => $this->request->getVar("Email"),
                "Mobile" => $this->request->getVar("Mobile"),
                "ParliamentId" => $this->request->getVar("ParliamentId"),
                "ConstituencyId" => $this->request->getVar("ConstituencyId"),
                "MandalId" => $this->request->getVar("MandalId"),
                "VillageId" => $this->request->getVar("VillageId"),
                "CommitteId"=>$this->request->getVar("CommitteId"),
                "CreatedDate"=>date('Y-m-d H:i:s'),
                "Password" => password_hash($this->request->getVar("Password"), PASSWORD_DEFAULT),
                'DOB'=>$this->request->getVar("DOB"),
                'Gender'=>$this->request->getVar("Gender"),
                'Skill'=>$this->request->getVar("Skill"),
                'OTP'=>$otp
            ];
                $table="users";
                $record_inserted_id=$this->ApiModel->insert_record($table,$table_data);
            if ($record_inserted_id) {   
                $this->smsSend($this->request->getVar("Mobile"),$otp);
              //  echo $response;
                // Process your response here
                // echo $response;




              //  $record_inserted_id=$this->ApiModel->insert_record($table,$table_data);
                $bUIdLength = strlen($record_inserted_id);
                switch($bUIdLength)
                {
                    case 1: $MembershipId = "MANATDP00000".$record_inserted_id;
                    break;
                    case 2: $MembershipId = "MANATDP0000".$record_inserted_id;
                    break;
                    case 3: $MembershipId = "MANATDP000".$record_inserted_id;
                    break;
                    case 4: $MembershipId = "MANATDP00".$record_inserted_id;
                    break;
                    case 5: $MembershipId = "MANATDP0".$record_inserted_id;
                    break;
                    case 7: $MembershipId = "MANATDP".$record_inserted_id;
                    break;
                    default: 
                    echo "Your favorite color is neither red, blue, nor green!";
                    
                }
                $where_parameter="u_id";
                $table_data=["MembershipId"=>$MembershipId];
                $table="users";
                $where_id=$record_inserted_id;
                $updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);

                $response = [
                    'status' => 200,
                    "error" => false,
                    'messages' => 'Successfully, user has been registered',
                    'data' => [
                                'OTP'=>$otp,
                                'MembershipId'=>$MembershipId
                            ]
                ];
            } else {
                $response = [
                    'status' => 500,
                    "error" => true,
                    'messages' => 'Failed to create user',
                    'data' => []
                ];
            }
        }
        return $this->respondCreated($response);
    }
    //user profile update
    //Activity Status File Uplode
    public function userProfileUpdate(){ 
          
        try{
                $u_id=$this->request->getVar('user_id'); 
                $file=$this->request->getFile('ProfileImage',FILTER_SANITIZE_STRING);

                if($file->isValid() && !$file->hasMoved()){
                        $file_name=$file->getRandomName();
                        $file->move('uploads/user_profile',$file_name); 
                }else{
                    $file_name='';
                }

                //update query
                $table_data=[
                    'ProfileImage'=>$file_name
                ];
                $where_parameter="u_id"; 
                $where_id=$this->request->getVar('user_id',FILTER_SANITIZE_STRING);
                $ActivityStatuId=$this->AdminModel->updateQuery('users',$table_data,$where_parameter,$where_id); 
                if($ActivityStatuId === false){						
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Unable to upload File',
                        'data' => [ ]
                    ];
                }else{
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Successfully Upload Profile Image',
                        'data' => [ 
                            'img_path'=>base_url()."/uploads/user_profile/".$file_name,
                        ]
                    ];
                }
                   
                //}
            }catch (Exception $ex){          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        
        return $this->respondCreated($response);
    }

    //get actvity
    public function getActivity(){ 
        $rules = [
            "u_id" => "required"
        ];
        $messages = [
            "u_id" => [
                "required" => "User Id Group"
            ]
        ];
        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
            //exit();
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                     $u_id=$this->request->getVar('u_id'); 
                    $Activity_details= $this->ApiModel->get_activity($u_id); 
                    foreach($Activity_details as $row){ 
                        $row->imagePath= base_url()."/uploads/pragram_activity_files/".$row->UploadResource;
                        $row->default_imagePath= base_url()."/uploads/default_images/Default.jpg";
                        $row->t_date=date('d-m-Y',strtotime($row->TargetCompletionDate));
                       // $row->imagePath= base_url();
                    }
                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Get Actvity details',
                        'data' => ["activities"=>$Activity_details]
                    ];
                   
              //  }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }         

        }
        return $this->respondCreated($response);
        
    }

    //fogot password send otp
    public function sendOtp(){ 
        $rules = [
            "Mobile" => "required"
        ];
        $messages = [
            "Mobile" => [
                "required" => "Regisatred Mobile Required"
            ]
        ];
        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{
            try {
                
                    $otp = rand(1231,7879); 
                     $where_id=$this->request->getVar('Mobile'); 
                     $where_parameter="Mobile";
                     $table_data=["OTP"=>$otp];
                     $table="users";
                     $updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
                     if ($updateQuery) {
                        $this->smsSend($where_id,$otp); 
                        $response = [
                            'status' => 200,
                            "error" => false,
                            'messages' => 'Successfully Send OTP',
                            'data' => ["OTP"=>$otp]
                        ];
                     }else{
                        $response = [ 
                            'status' => 401,
                            "error" => true,
                            'messages' => 'Unable to send OTP',
                            'data' => []
                        ];
                     }    
                   
                
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }         

        }
        return $this->respondCreated($response);
    }
    //SMS Integration
    public function smsSend($mobile,$otp){ 
        $apiKey = ('NTkzMjRkMzI3MzMyNDI2ZTczNjI1MDY3NzM1MTZmNzM=');
        // Message details
        $OTP = $otp;
        $numbers =$mobile;
        $sender = urlencode("Volta");
        $message = rawurlencode('Dear User, your OTP for Volta App Login is '.$OTP.'.Do not share your OTP with anyone .');   
        // Prepare data for POST request
        $data = array('apikey' => $apiKey, 'numbers' => $numbers, "sender"=> $sender, "message" => $message);
        // Send the POST request with cURL
        $ch = curl_init('https://api.textlocal.in/send/');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch); 
    }

    //validate otp
    public function verifiedOtp(){
        $rules = [
            "Mobile" => "required",
            "OTP"=>"required",
        ];
        $messages = [
            "Mobile" => [
                "required" => "Regisatred Mobile Required"
            ],"OTP" => [
                "required" => "OTP is required"
            ],
        ];

        if (!$this->validate($rules, $messages)){
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{
            try {
              
                     $Mobile=$this->request->getVar('Mobile');
                     $otp=$this->request->getVar('OTP');
                     $table="users";
                     $where_parameter = ['Mobile' => $Mobile, 'OTP' => $otp];
                     if ($this->ApiModel->getWhereQuery($table,$where_parameter)) {

                        $where_parameter="Mobile";
                        $table_data=["MobileVerified"=>1];
                        $table="users";
                        $where_id=$Mobile;  
                        $updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);


                        $response = [
                            'status' => 200,
                            "error" => false,
                            'messages' => 'OTP verified successfully',
                            'data' => []
                        ];
                     }else{
                        $response = [
                            'status' => 401,
                            "error" => true,
                            'messages' => 'Incorrect OTP',
                            'data' => []
                        ]; 
                    }    
                   
            
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }         

        }
        return $this->respondCreated($response);
    }

    //change password 
    public function changePassword(){
        $rules = [
            "Mobile" => "required",
            "Password"=>"required",
        ];
        $messages = [
            "Mobile" => [
                "required" => "Regisatred Mobile Required"
            ],"Password" => [
                "required" => "Password is required"
            ],
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{
            try {
                    $where_id=$this->request->getVar('Mobile');                    
                    $password= password_hash($this->request->getVar("Password"), PASSWORD_DEFAULT);
                    $where_parameter="Mobile";
                    $table_data=["Password"=>$password];
                    $table="users";
                    $updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
                     if ($updateQuery) {
                        $response = [
                            'status' => 200,
                            "error" => false,
                            'messages' => 'Password updated successfully',
                            'data' => []
                        ];
                     }else{
                        $response = [
                            'status' => 401,
                            "error" => true,
                            'messages' => 'Unable to Update Password',
                            'data' => []
                        ];
                     }  
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Unable to update',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }  
        }
        return $this->respondCreated($response);
    }

    public function userUpdate(){
        $rules = [
            "u_id" => "required"
        ];
        $messages = [
            "u_id" => [
                "required" => "user id required"
            ]
        ];

        if (!$this->validate($rules, $messages)){
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
        }else{
            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();       
            // $token = $authHeader;      
            try{
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $table_data=[
                        'FirstName'=>$this->request->getVar('FirstName',FILTER_SANITIZE_STRING),
                        'Skill'=>$this->request->getVar('Skill',FILTER_SANITIZE_STRING),
                        'DisplayName'=>$this->request->getVar('DisplayName',FILTER_SANITIZE_STRING),
                        'LastName'=>$this->request->getVar('LastName',FILTER_SANITIZE_STRING), 
                        'FBLink'=>$this->request->getVar('FBLink',FILTER_SANITIZE_STRING),
                        'TwitterLink'=>$this->request->getVar('TwitterLink',FILTER_SANITIZE_STRING), 
                        'InstaLink'=>$this->request->getVar('InstaLink',FILTER_SANITIZE_STRING),
                        'YouTubeLink'=>$this->request->getVar('YouTubeLink',FILTER_SANITIZE_STRING),
                    ];
                    $u_id=$this->request->getVar('u_id',FILTER_SANITIZE_STRING);
                    $table="users";
					$where_parameter="u_id";
					$where_id=$u_id; 
				    if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){
                        $response = [
                            'status' => 401,
                            "error" => true,
                            'messages' => 'Unable to Update Profile',
                            'data' => []
                        ];
                    }else{
                        $response = [
                            'status' => 200, 
                            "error" => false,
                            'messages' => 'Profile updated successfully',
                            'data' => []
                        ];
                    }
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
               
            }
           
        }
        return $this->respondCreated($response);
    }
    //get activity by id
    public function getActivityById(){ 
        $rules = [
            "ActivityStatuId" => "required"
        ];
        $messages = [
            "ActivityStatuId" => [
                "required" => "Activity Status  Id Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
        }else{            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader; 
            //exit();
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){

                     $ActivityStatuId=$this->request->getVar('ActivityStatuId'); 
                   // exit();
                    $Activity_details= $this->ApiModel->get_activityById($ActivityStatuId); 

                    $where_id=$ActivityStatuId;
                    $where_parameter="ActivityStatuId";
                    $table="activitystatus";
                    $this->CheckActivityView($where_id,$where_parameter,$table);
                  //  print_r($Activity_details);
                   // exit();
                    foreach($Activity_details as $row){   
                       $Activity_details['imagePath']=base_url()."/uploads/user_uplode_activity_files/";
                       //$Activity_details['parent_imagePath']= base_url()."/uploads/pragram_activity_files/".$row['UploadResource'];
                       $Activity_details['parent_imagePath']=$this->s3GetObjects('program_activity_files',$row['UploadResource']); 

                       if(!empty($Activity_details['InMediaCovarageFile'])){ 
                               $Activity_details['InMediaCovarageFile']=$this->s3GetObjects('user_uplode_activity_files',$row['InMaterialUsageFormatFile']);
                        }else{
                            $Activity_details['InMediaCovarageFile']="";
                        }

                        if(!empty($Activity_details['InMaterialUsageFormatFile'])){ 
                            $Activity_details['InMaterialUsageFormatFile']=$this->s3GetObjects('user_uplode_activity_files',$row['InMaterialUsageFormatFile']);
                        }else{
                            $Activity_details['InMaterialUsageFormatFile']="";
                        }

                    //    $Activity_details['InMediaCovarageFile']=$this->s3GetObjects('user_uplode_activity_files',$row['InMaterialUsageFormatFile']);
                    //    $Activity_details['InMaterialUsageFormatFile']=$this->s3GetObjects('user_uplode_activity_files',$row['InMaterialUsageFormatFile']);
                     
                       $Activity_details['t_date']=date('d-m-Y',strtotime($row['TargetCompletionDate']));
                    }
                  //  print_r($Activity_details);
                   // exit();
                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Get Actvity details',
                        'data' => ["activities"=>$Activity_details]
                    ];
                   
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage(),'Line'=>$ex->getLine()]
                ];
            }         

        }
        return $this->respondCreated($response);
    }

    //Views Count
    public function CheckActivityView($where_id,$where_parameter,$table){ 
        $where_id=$where_id;
        $where_parameter=$where_parameter;
        $result=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
        if($result['CheckView']=="0"){ 
            $table_data=['CheckView'=>1]; 
            $where_parameter=$where_parameter;
            $where_id=$where_id; 
            $this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
        }else{
            
        }
    }
    //user Activity update
    public function updateUserActivity(){
        $rules = [
            "ActivityStatuId"=>"required",
        ];
        $messages = [
            "ActivityStatuId" => [
                "required" => "ActivityId is required"
            ],
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
        }else{
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();       
            // $token = $authHeader;      
            try{
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){ 
                    //countaing grading
                    $marks=0;
                    if($this->request->getVar('ConstituencyProgramConducted',FILTER_SANITIZE_STRING)=="Yes"){
                        $marks=4;
                    }
                    if($this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING)=="Yes"){
                        $marks +=1;
                    }
                    if($this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING)=="Yes"){
                        
                    }
                    if($this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING)=="Yes"){
                        $marks +=2;
                    }
                    if($this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING)=="Yes"){
                        $marks +=1;
                    }
                    if($this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING)=="Yes"){
                        $marks +=1;
                    }
                    if(!empty($this->request->getVar('NeutralPeopleParticipatedCount',FILTER_SANITIZE_STRING))){
                        $marks +=1;
                    }
                    if($marks >8 ){
                        $grade="A";
                    }elseif(($marks <=8) and ($marks >6)){
                        $grade="B";
                    }elseif(($marks <=6) and ($marks >5)){
                        $grade="C";
                    }else{
                        $grade="D";
                    }  
                    $total=10;
                    $ActivityStatuId=$this->request->getVar('ActivityStatuId',FILTER_SANITIZE_STRING);
                    if($this->request->getVar('Activity_status',FILTER_SANITIZE_STRING) == "Completed"){
                        $where_parameter="ActivityStatuId";
                        $where_id=$ActivityStatuId;
                        $resultData=$this->AdminModel->getRowTableById('activitystatus',$where_parameter,$where_id);
                        if(!empty($resultData['CompletedDate'])){
                            $CompletedDate=$resultData['CompletedDate'];
                        }else{
                            $CompletedDate=date('Y-m-d H:i:s');
                        }
                        
                    }else{
                        $CompletedDate="";
                    }
                   
                    $percetage=$marks/$total*100;
                    $table_data=[
                    'Activity_status'=>$this->request->getVar('Activity_status',FILTER_SANITIZE_STRING),
                    'ConstituencyProgramConducted'=>$this->request->getVar('ConstituencyProgramConducted',FILTER_SANITIZE_STRING),
                    'BannerDisplayed'=>$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING),
                    'ParliamentPresidentParticipated'=>$this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING),
                    'MlaInchargeParticipation'=>$this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING),
                    'ConstituencyLeadersParticipated'=>$this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING),
                    'NoOfCadreParticipatedCount'=>$this->request->getVar('NoOfCadreParticipatedCount',FILTER_SANITIZE_STRING),
                    'NeutralPeopleParticipatedCount'=>$this->request->getVar('NeutralPeopleParticipatedCount',FILTER_SANITIZE_STRING),
                    'MediaCovarage'=>$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),
                    'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
                    'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),
                    'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),
                    'Grade'=>$grade,
                    'Marks'=>$marks,
                    'CompletedDate'=>$CompletedDate, 
                    'Percentage'=>$percetage,
                    'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
                    'Remarks'=>$this->request->getVar('Remarks',FILTER_SANITIZE_STRING), 
                    'UpdatedDate'=>date('Y-m-d H:i:s') 




                    //    'NumberOfPeopleParticipate'=>$this->request->getVar('NumberOfPeopleParticipate',FILTER_SANITIZE_STRING),
                    //    'MediaCovarage'=>$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING), 
                   //     'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
                     //   'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),
                    //    'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),
                     //   'PublicResponse'=>$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),
                     //   'InPublicResponse'=>$this->request->getVar('InPublicResponse',FILTER_SANITIZE_STRING),
                     //   'AnySpecialActivities'=>$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),
                     //   'SocialMediaCoverage'=>$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),
                      //  'InSocialMediaCoverage'=>$this->request->getVar('InSocialMediaCoverage',FILTER_SANITIZE_STRING),
                      //  "InAnySpecialActivities"=>$this->request->getVar('InAnySpecialActivities',FILTER_SANITIZE_STRING),
                      //  'LeadORCommittee_Participation'=>$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),
                     //   'InLeadORComm_Participation'=>$this->request->getVar('InLeadORComm_Participation',FILTER_SANITIZE_STRING),
                       // 'SocialListingFromGround'=>$this->request->getVar('SocialListingFromGround',FILTER_SANITIZE_STRING),
                       
                    ]; 
                   
                    $table="activitystatus";
					$where_parameter="ActivityStatuId";
					$where_id=$ActivityStatuId;  
				    if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){

                        $response = [
                            'status' => 401,
                            "error" => true,
                            'messages' => 'Unable to Update Profile',
                            'data' => []
                        ];
                    }else{
                        $Points=20;
                        $where_parameter='ActivityStatuId';
                        $where_id=$ActivityStatuId; 
                        $getActivitDetails=$this->AdminModel->getRowTableById('activitystatus',$where_parameter,$where_id);
                        $user_id=$getActivitDetails['UserId'];


                         //MediaCovarage 1
                         $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),'MediaCovarage',$Points,'Pending');

                        //MaterialUsageFormat 2 
                        $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),'MaterialUsageFormat',$Points,'Pending');

                        //public reaponse 3 
                        $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),'PublicResponse',$Points,'Pending');

                        //spacial activity 4
                        $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),'AnySpecialActivities',$Points,'Pending');

                        //Social media covara     5                     
                        $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),'SocialMediaCoverage',$Points,'Pending');
                        
                        //LeadORCommittee_Participation 6
                        $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),'LeadORCommittee_Participation',$Points,'Pending');

                        $response = [
                            'status' => 200, 
                            "error" => false,
                            'messages' => 'Program Activity Successfully Update',
                            'data' => []
                        ];
                    }
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => $ex->getMessage(),
                    'data' => ['status'=>$ex->getMessage()]
                ];
               
            }
        }
        return $this->respondCreated($response); 
    }

    //delete files
    public function deleteProgramActivityFile(){
        
                $rules = [
                    "ActivityStatuId" => "required"
                ];
                $messages = [
                    "NewsFeedId" => [
                        "ActivityStatuId" => "Activity Statu Id Required"
                    ]
                ];
                if (!$this->validate($rules, $messages)){
                    $response = [
                        'status' => 500,
                        'error' => true,
                        'message' => $this->validator->getErrors(),
                        'data' => []
                    ];
                    
                }else{ 
                    // $key = $this->getKey();
                    // $authHeader = $this->request->getHeader("Authorization");
                    // $authHeader = $authHeader->getValue();
                    // $token = $authHeader;
                    try {
                        // $decoded = JWT::decode($token, $key, array("HS256"));
                        // if ($decoded){

                            $ActivityStatuId=$this->request->getVar('ActivityStatuId',FILTER_SANITIZE_STRING);
                            $FileType=$this->request->getVar('FileType',FILTER_SANITIZE_STRING);
                            $table_data=[$FileType=>""];
                            $where_parameter="ActivityStatuId";
                            $where_id=$ActivityStatuId;
                            $update=$this->AdminModel->updateQuery('activitystatus',$table_data,$where_parameter,$where_id);

                            $response = [
                                'status' => 200,
                                "error" => false,
                                'messages' => 'Successfully Deleted',
                                'data' => [ ]
                            ];
                        
                       // }
                    }catch (Exception $ex) {          
                        $response = [
                            'status' => 401,
                            'error' => true,
                            'messages' => 'Access denied',
                            'data' => ['Error'=>$ex->getMessage()]
                        ];
                    } 
                }
        return $this->respondCreated($response);
    }

    

    
    //actvitiy stataus point count
    public function actvitiyStatusPointsCount($user_id,$ActivityStatuId,$PointsFromDesc,$FromName,$Points,$PointStatus){
        if($PointsFromDesc=="1"){
            $where_data=["PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName,"userId"=>$user_id];
            $getCount=$this->AdminModel->tableRowsCount('pointsdetails',$where_data); 
            if($getCount=="1"){
                
            }else{
                $table_data=["userId"=>$user_id,"PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName,"Points"=>$Points,"PointStatus"=>$PointStatus];
                $this->ApiModel->insert_record('pointsdetails',$table_data);
            }
        }else{
            $where_data=["userId"=>$user_id,"PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName];
            $this->ApiModel->deleteRecord('pointsdetails',$where_data);
        }
    }

    //get feeds
    public function getFeeds(){
       
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $parameters=array('NewsFeedId','Title','Description','FeedType','CreatedDate','FeedFileName','Links','IsActive','1');
                    $order_by='NewsFeedId'; 
                    $Feed_details=$this->AdminModel->getQueryFromTable('newsfeed',$parameters,$order_by); 
                    $i=0;
                    $UserId=$this->request->getVar('UserId'); 
                    foreach($Feed_details as $row){ 
                        
                        $UserId=$this->request->getVar('UserId'); 
                        $where_data=["ViewFrom"=>"feeds","ViewFromId"=>$row['NewsFeedId'],"UserId"=>$UserId];
                        $ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
                        if($ViewData){
                            $CheckView=$ViewData;
                        }else{
                            $CheckView=0;
                        }
                        $Feed_details[$i]['CheckView']=$CheckView; 
                     
                        $NewsFeedId=$row['NewsFeedId'];
                        //get total views
                        $where_total_data=["ViewFrom"=>"feeds","ViewFromId"=>$row['NewsFeedId']];
                        $Feed_details[$i]['TotalViews']=$this->AdminModel->tableRowsCount('ViewsCheck',$where_total_data);



                        //$likes=$this->ApiModel->getNewsFeedLikesCount($NewsFeedId);
                        $where_data=['NewsFeedId'=>$NewsFeedId];
                        $likes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data);

                        $where_data=['NewsFeedId'=>$NewsFeedId,'UserId'=>$UserId]; 
                        $islikes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data); 
                        if($islikes){
                            $isLiked=1;
                        }else{
                            $isLiked=0;
                        }
                        $Feed_details[$i]['newdFeedLikesCount']=$likes;  
                        $Feed_details[$i]['isLiked']=$isLiked; 
                        $Feed_details[$i]['OnlyDate']=date('d-m-Y',strtotime($row['CreatedDate']));   
                        //$Feed_details[$i]['OnlyDate']=$row['CreatedDate'];
                        //$Feed_details[$i]['img_path']=base_url()."/uploads/feed_files/".$row['FeedFileName']; 
                      //  $Feed_details[$i]['img_pathsss']= $row['FeedFileName'];
                     //   echo '<br/>';
                        if($row['FeedType']!="Links"){ 
                            $Feed_details[$i]['img_path']=$this->s3GetObjects('feed_files',$row['FeedFileName']);
                        }
                      //  $Feed_details[$i]['img_path']=$this->s3GetObjects('feed_files',$row['FeedFileName']);
                       // $feeddetails['img_path']=$this->s3GetObjects('feed_files',$feeddetails['FeedFileName']);

                        //Extention format 
                        $paths=$row['FeedFileName'];                        
                        $extension = substr(strrchr($paths, '.'), 1);
                        $Feed_details[$i]['extension']  = $extension;
                        
                        $where_data=["SharedFrom"=>"feeds","SharedFromId"=>$NewsFeedId ]; 
                        $ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
                        if($ShareCount){
                            $ShareCount=$ShareCount;
                        }else{
                            $ShareCount=0;
                        } 
                        $Feed_details[$i]['ShareCount']=$ShareCount;
                        
                        $i++;
                       
                    }

                  /*
                    $UserId=$this->request->getVar('UserId');  
                    $Feed_details=$this->ApiModel->getFeedsForApp1($UserId); 
                    $i=0;
                    foreach($Feed_details as $row){

                        $Feed_details[$i]['OnlyDate']=date('d-m-Y',strtotime($row['CreatedDate'])); 

                        $paths=$row['FeedFileName'];                         
                        $extension = substr(strrchr($paths, '.'), 1);
                        $Feed_details[$i]['extension']  = $extension;
                        /*
                        if($row['FeedType']!="Links"){ 
                            //   $Feed_details[$i]['img_path']="https://manatdp-dev-data.ap-south-1.linodeobjects.com/feed_files/".$row['FeedFileName']; 
                               $Feed_details[$i]['img_path']=$this->s3Url()."fd/".$row['FeedFileName'];
                           }else{ 
                               $Feed_details[$i]['img_path']="";
                           } 
                           if($row['FeedType']!="Links"){ 
                                 $Feed_details[$i]['img_path']=$this->s3GetObjects('feed_files',$row['FeedFileName']);
                            }
                           $i++;
                    } */

                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Get Feed details',
                        'data' => [
                                "feeds"=>$Feed_details,
                                "path"=>base_url()."/uploads/feed_files/"
                            ]
                    ];
                   
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage(),'Line'=>$ex->getLine(),$ex->getFile(),$ex->getCode()]
                ];
            } 
        return $this->respondCreated($response);
    }

    
    //get feeds by id
    public function getFeedById(){
        $rules = [
            "NewsFeedId" => "required"
        ];
        $messages = [
            "NewsFeedId" => [
                "required" => "News Feed Id Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
            //exit();
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                     $NewsFeedId=$this->request->getVar('NewsFeedId'); 
                     $table="newsfeed";
                     $where_id=$NewsFeedId;
                     $where_parameter="NewsFeedId";
                     $feeddetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
                    // $feeddetails['img_path']=base_url()."/uploads/feed_files/".$feeddetails['FeedFileName'];
                    
                     if($feeddetails['FeedType']!="Links"){ 
                        $feeddetails['img_path']=$this->s3GetObjects('feed_files',$feeddetails['FeedFileName']);
                    }

                     $UserId=$this->request->getVar('UserId'); 

                    // $NewsFeedId=$row['NewsFeedId'];
                    $where_data=['NewsFeedId'=>$NewsFeedId]; 
                    $likes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data);

                    //total views count                   
                    $where_total_data=["ViewFrom"=>"feeds","ViewFromId"=>$NewsFeedId];
                    $feeddetails['TotalViews']=$this->AdminModel->tableRowsCount('ViewsCheck',$where_total_data); 

                    $where_data=['NewsFeedId'=>$NewsFeedId,'UserId'=>$UserId]; 
                    $islikes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data); 
                    if($islikes){
                        $isLiked=1;
                    }else{
                        $isLiked=0;
                    }
                    $feeddetails['newdFeedLikesCount']=$likes;  
                    $feeddetails['isLiked']=$isLiked; 
                    //share count
                    $where_data=["SharedFrom"=>"feeds","SharedFromId"=>$NewsFeedId ]; 
                    $ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
                    if($ShareCount){
                        $ShareCount=$ShareCount;
                    }else{
                        $ShareCount=0;
                    } 
                    $feeddetails['ShareCount']=$ShareCount;

                      //Extention format 
                      $paths=$feeddetails['FeedFileName'];                         
                      $extension = substr(strrchr($paths, '.'), 1);
                      $Feed_details['extension']  = $extension;

                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Get Actvity details',
                        'data' => [
                            "feeddetails"=>$feeddetails,
                            "path"=>base_url()."/uploads/feed_files/"
                            ]
                    ];
                   
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }  
        }
        return $this->respondCreated($response);
    }

    //get E paper List
    public function getEpaper(){        
      //  $key = $this->getKey();
       // $authHeader = $this->request->getHeader("Authorization");
        //$authHeader = $authHeader->getValue();
        // $token = $authHeader;
        try {
            // $decoded = JWT::decode($token, $key, array("HS256"));
            // if ($decoded){
                $parameters=array('EpaperId','Title','EpaperFileName','epaper_thumbnail','file_date','CreatedDate','IsActive','1');
                $order_by='file_date';
                $epaperdetails=$this->AdminModel->getQueryFromTable('epaper',$parameters,$order_by);
                $i=0;
                foreach($epaperdetails as $row){

                        $UserId=$this->request->getVar('UserId'); 
                        $where_data=["ViewFrom"=>"epaper","ViewFromId"=>$row["EpaperId"],"UserId"=>$UserId];
                        $ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
                        if($ViewData){
                            $CheckView=$ViewData;
                        }else{
                            $CheckView=0;
                        }
                        $epaperdetails[$i]['CheckView']=$CheckView;
                      //  $epaperdetails[$i]['img_path']=base_url()."/uploads/e_paper/".$row['EpaperFileName'];
                        $epaperdetails[$i]['img_path']=$this->s3GetObjects('e_paper',$row['EpaperFileName']);     
                        $epaperdetails[$i]['thumb_img_path']=base_url()."/uploads/e_paper/".$row['epaper_thumbnail'];
                        $i++;
                }
                $response = [
                    'status' => 200,
                    "error" => false, 
                    'messages' => 'Successfully Get E Paper details',
                    'data' => [
                            "epaperdetails"=>$epaperdetails,
                            "path"=>base_url()."/uploads/epaper_files/"
                        ]
                ];
               
            // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        return $this->respondCreated($response);
    }
    //get s3 object images
	public function s3GetObjects($bucket,$file_name){   
		
        $client=$this->s3Details();
		$file_url = $client->getObjectUrl($bucket, $file_name);
		return $file_url;
	}	
    //s3 uplode
    public function s3Upload($bucket,$file_Path){
		$client=$this->s3Details();
		//$file_Path = base_url()."/uploads/gallery/". $file_name; 
		$key = basename($file_Path); 
		$sha256 = hash_file("sha256", $file_Path);
		$result = $client->putObject([
			"Bucket" =>$bucket,
			"Key" => $key,
			"SourceFile" => $file_Path,
			"ACL" => "public-read",
			"ContentSHA256" => $sha256,
			"ContentLength"=>'9',
		]);
		return $result['ObjectURL'];
	}
    //S3 delete function 
    public function s3DeleteObjects($bucket,$file_name){  
        $client=$this->s3Details();
        $client->deleteObject(['Bucket' =>$bucket, 'Key' =>$file_name]);
    }
    //s3 object keys
	private function s3Details(){
		//define('AWS_KEY', 'KTL0LE9OZVCDNMXOR8Y1');
		$AWS_KEY="846UE3L4ZEPAUX7F779L";
	//	define('AWS_SECRET_KEY', '6VYBOhUYiWoC1eXdZVz8ldqdfd6llBeKvJJqMXXC');
		$AWS_SECRET_KEY="ym3B0tjJIRsFNiujIFPDwABPw2fWpndfxFOE4bm5";
       // $ENDPOINT = 'https://manatdp.ap-south-1.linodeobjects.com';  
		$ENDPOINT = 'https://manatdp.ap-south-1.linodeobjects.com';  

		return 	$client = new S3Client([
			'region' => 'ap-south-1',
			'version' => 'latest',
			'endpoint' => $ENDPOINT,
			'credentials' => [
				'key' => $AWS_KEY,
				'secret' => $AWS_SECRET_KEY
			],
			'use_path_style_endpoint' => true
		]); 
	}
    //get SM Task List
    public function getSmList(){  
        $rules = [
            "SelectedGroups" => "required"
        ];
        $messages = [
            "SelectedGroups" => [
                "required" => "Group Ids Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{  
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
        try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $SelectedGroups=$this->request->getVar('SelectedGroups');   
                    $group_ids= explode(",",$SelectedGroups);
                                                      
                   // $taskdetails=$this->AdminModel->getTasks(); 
                   //  $taskdetails=$this->ApiModel->getTasksByGroupIds($SelectedGroups,$group_ids);  
                     $taskdetails=$this->ApiModel->getTasksByGroupIdsNew($SelectedGroups,$group_ids);  
                    $i=0;
                    foreach($taskdetails as $row){  
                        
                        $UserId=$this->request->getVar('u_id'); 
                        $where_data=["ViewFrom"=>"smtasks","ViewFromId"=>$row["TaskId"],"UserId"=>$UserId];
                        $ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
                        if($ViewData){  
                            $CheckView=1;
                        }else{
                            $CheckView=0;
                        }
                        $taskdetails[$i]['CheckView']=$CheckView; 
 
                        if($row['ContentType'] != 'Text'){ 
                           //$taskdetails[$i]['img_path']=base_url()."/uploads/task_files/".$row['Image'];
                            $taskdetails[$i]['img_path']=$this->s3GetObjects('task_files',$row['Image']);  
                        }
                        $paths=$row['Image'];                         
                        $extension = substr(strrchr($paths, '.'), 1);
                        $taskdetails[$i]['extension']  = $extension;
                        $i++;
                    }
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Successfully Get SM Task Details',
                        'data' => [
                                "taskdetails"=>$taskdetails,
                                "path"=>base_url()."/uploads/task_files/"
                            ]
                    ];
                
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine(),'file'=>$ex->getFile(),'code'=>$ex->getCode()]
                ];
            } 
        }
        return $this->respondCreated($response);
    }

    public function getSmTaskDetailsById(){ 
        $rules = [
            "TaskId" => "required"
        ];
        $messages = [
            "TaskId" => [
                "required" => "Task Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{  
        // $key = $this->getKey();
        // $authHeader = $this->request->getHeader("Authorization");
        // $authHeader = $authHeader->getValue();
        //  $token = $authHeader;
        try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                     $TaskId=$this->request->getVar('TaskId'); 
                        //exit();             
                   // $taskdetails=$this->AdminModel->getTasks();
                   // $taskdetails=$this->ApiModel->getTasksByGroupIds($SelectedGroups,$group_ids); 
                    $table="tasks";
                    $where_id=$TaskId;
                    $where_parameter="TaskId";
                    $taskdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
                   // $taskdetails['img_path']=base_url()."/uploads/task_files/".$taskdetails['Image'];
                    $taskdetails['img_path']=$this->s3GetObjects('task_files',$taskdetails['Image']);

                    //share count
                    $where_data=["SharedFrom"=>"smtasks","SharedFromId"=>$TaskId ]; 
                    $ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
                    if($ShareCount){
                        $ShareCount=$ShareCount;
                    }else{
                        $ShareCount=0;
                    } 
                    $taskdetails['ShareCount']=$ShareCount;

                    //views count
                    $where_data=["ViewFrom"=>"smtasks","ViewFromId"=>$TaskId ]; 
                    $ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
                    if($ViewData){
                        $CheckView=$ViewData;
                    }else{
                        $CheckView=0; 
                    } 
                    $taskdetails['totalviews']=$CheckView;    
                    
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Successfully Get SM Task Details',
                        'data' => [
                                "taskdetails"=>$taskdetails,
                                "path"=>base_url()."/uploads/task_files/"
                            ]
                    ];
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        }
        return $this->respondCreated($response);
    }

    //get gallery
    public function getGalleryList(){       
        // $key = $this->getKey();
        // $authHeader = $this->request->getHeader("Authorization");
        // $authHeader = $authHeader->getValue();
        // $token = $authHeader;
        try {
            // $decoded = JWT::decode($token, $key, array("HS256"));
            // if ($decoded){
                $parameters=array('*','IsActive','1');
                $order_by='GalleryId';
                $gallerydetails=$this->AdminModel->getQueryFromTable('gallery',$parameters,$order_by);
                $i=0;
                $UserId=$this->request->getVar('UserId'); 
                foreach($gallerydetails as $row){
                    
                  //  $gallerydetails[$i]['img_path']=base_url()."/uploads/gallery/".$row['GalaryFileName'];
                    $gallerydetails[$i]['img_path']=$this->s3GetObjects('gallery',$row['GalaryFileName']); 

                    $where_data=['GalleryId'=>$row['GalleryId']]; 
                    $Totallikes=$this->AdminModel->tableRowsCount('gallerylikes',$where_data);

                    $where_data=['GalleryId'=>$row['GalleryId'],'UserId'=>$UserId]; 
                    $islikes=$this->AdminModel->tableRowsCount('gallerylikes',$where_data);
                    if($islikes){
                        $isLiked=1;
                    }else{
                        $isLiked=0;
                    }
                    $gallerydetails[$i]['GalleryLikesCount']=$Totallikes;  
                    $gallerydetails[$i]['isLiked']=$isLiked; 

                    $where_data=["SharedFrom"=>"gallery","SharedFromId"=>$row["GalleryId"] ]; 
                    $ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
                    if($ShareCount){
                        $ShareCount=$ShareCount;
                    }else{
                        $ShareCount=0;
                    } 
                    $gallerydetails[$i]['ShareCount']=$ShareCount;  

                    $paths=$row['GalaryFileName'];                          
                    $extension = substr(strrchr($paths, '.'), 1);
                    $gallerydetails[$i]['extension']  = $extension;

                    $i++;
                }
                $response = [
                    'status' => 200,
                    "error" => false, 
                    'messages' => 'Successfully Get Gallery details',
                    'data' => [
                            "epaperdetails"=>$gallerydetails,
                            "path"=>base_url()."/uploads/gallery/"
                        ]
                ];
               
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        return $this->respondCreated($response);
    }

    //Activity Status File Uplode
    public function userActivityFilesUploads(){ 
          
        $rules = [
            "Activity_status_id" => "required"
        ];
        $messages = [
            "Activity_status_id" => [
                "required" => "Activity Status Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{ 
             try {
                    $Activity_status_id=$this->request->getVar('Activity_status_id'); 
                    $metric_type=$this->request->getVar('metric_type');  
                    $file=$this->request->getFile($metric_type,FILTER_SANITIZE_STRING);

                    if($file->isValid() && !$file->hasMoved()){
                       // $old_img=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
                       
                          $file_name=$file->getRandomName();
                         $file->move('uploads/user_uplode_activity_files',$file_name);  

                          $file_Path = base_url()."/uploads/user_uplode_activity_files/". $file_name; 
							$this->s3Upload('user_uplode_activity_files',$file_Path); 
							$url="./uploads/user_uplode_activity_files/".$file_name;
							unlink($url);
                    }else{
                       // $file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
                        $file_name='';
                    }

                    //update query
                    $table_data=[
                        $metric_type=>$file_name
                    ];
                    $where_parameter="ActivityStatuId"; 
					$where_id=$this->request->getVar('Activity_status_id',FILTER_SANITIZE_STRING);
					$ActivityStatuId=$this->AdminModel->updateQuery('activitystatus',$table_data,$where_parameter,$where_id); 
                    if($ActivityStatuId === false){						
                        $response = [
                            'status' => 200,
                            "error" => false, 
                            'messages' => 'Unable to upload File',
                            'data' => [ ]
                        ];
                    }else{
                        $response = [
                            'status' => 200,
                            "error" => false, 
                            'messages' => 'Successfully Uploade File',
                            'data' => [ ]
                        ];
                    }
                   
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        }
        return $this->respondCreated($response);
    }
    //get Cadre listing
    public function getCadreListeningList(){ 
        $rules = [
            "ConstituencyId" => "required",
            "Authorization"=>"required"
        ];
        $messages = [
            "TaskId" => [
                "required" => "Constituency Id Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{  
        // $key = $this->getKey();
        // $authHeader = $this->request->getHeader("Authorization");
        // $authHeader = $authHeader->getValue();
        //  $token = $authHeader;
        try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $ConstituencyId=$this->request->getVar('ConstituencyId'); 
                    $table="cadrelisteningdetails";
                    $where_parameter=[
                        "ConstituencyId"=>$ConstituencyId
                    ];
                    $CadreListeningDetails=$this->ApiModel->getWhereQuery($table,$where_parameter);

                    //non constency cadre listening
                    $NonConstCadreListeningDetails=$this->ApiModel->getNonConstCadreListeningList($ConstituencyId);
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Successfully Get SM Task Details',
                        'data' => [
                                "CadreListeningDetails"=>$CadreListeningDetails,
                                "NonConstCadreListeningDetails"=>$NonConstCadreListeningDetails
                            ]
                    ];
                //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        }
        return $this->respondCreated($response);
    }

    //public function NewsFeedLike
    public function newsFeedLikesPost(){ 
        $rules = [
            "NewsFeedId" => "required"
        ];
        $messages = [
            "NewsFeedId" => [
                "required" => "News Feed Id Required"
            ]
        ];

        if(!$this->validate($rules, $messages)){
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
            //exit();
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                     $NewsFeedId=$this->request->getVar('NewsFeedId'); 
                     $UserId=$this->request->getVar('UserId'); 
                     $NewsFeedLike=$this->request->getVar('NewsFeedLike');
                     if($NewsFeedLike){
                         $table_data=['NewsFeedId'=>$NewsFeedId,'UserId'=>$UserId,'CreatedDate'=>date('Y-m-d H:i:s')];
                         $this->ApiModel->insert_record('newsfeedlikes',$table_data);
                     }else{
                         $where_data=['NewsFeedId'=>$NewsFeedId,'UserId'=>$UserId];
                        $this->ApiModel->deleteRecord('newsfeedlikes',$where_data);
                     }
                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Added Like',
                        'data' => [ ]
                    ];
                   
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }         

        }
        return $this->respondCreated($response);
    }

     //get Cadre listing
     public function getNewdFeedLikes(){ 
        $rules = [
            "NewsFeedId" => "required"
        ];
        $messages = [
            "NewsFeedId" => [
                "required" => "News Feed Id Required"
            ]
        ];

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{  
        // $key = $this->getKey();
        // $authHeader = $this->request->getHeader("Authorization");
        // $authHeader = $authHeader->getValue();
        //  $token = $authHeader;
        try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $NewsFeedId=$this->request->getVar('NewsFeedId'); 
                    $newdFeedLikesCount=$this->ApiModel->getNewsFeedLikesCount($NewsFeedId);
                    $response = [
                        'status' => 200,
                        "error" => false, 
                        'messages' => 'Successfully Get Likes',
                        'data' => [
                                "NewsFeedLikeCount"=>$newdFeedLikesCount
                            ]
                    ];
               // }
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            } 
        }
        return $this->respondCreated($response);
    }

    //get likes gallery
    public function galleryLikesPost(){  
        $rules = [
            "GalleryId" => "required"
        ];
        $messages = [
            "GalleryId" => [
                "required" => "Gallery Id Required"
            ]
        ];

        if(!$this->validate($rules, $messages)){
            $response = [
                'status' => 500,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];
            
        }else{            
            // $key = $this->getKey();
            // $authHeader = $this->request->getHeader("Authorization");
            // $authHeader = $authHeader->getValue();
            //  $token = $authHeader;
            //exit();
            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                     $GalleryId=$this->request->getVar('GalleryId'); 
                     $UserId=$this->request->getVar('UserId'); 
                     $GalleryLike=$this->request->getVar('GalleryLike');
                     if($GalleryLike=='1'){
                        $table_data=['GalleryId'=>$GalleryId,'UserId'=>$UserId,'CreatedDate'=>date('Y-m-d H:i:s')];
                        $this->ApiModel->insert_record('gallerylikes',$table_data);
                     }else{
                        $where_data=['GalleryId'=>$GalleryId,'UserId'=>$UserId]; 
                        $this->ApiModel->deleteRecord('gallerylikes',$where_data);
                     }
                    $response = [
                        'status' => 200,
                        "error" => false,
                        'messages' => 'Successfully Added Like',
                        'data' => [ ]
                    ];
                   
               //}
            }catch (Exception $ex) {          
                $response = [
                    'status' => 401,
                    'error' => true,
                    'messages' => 'Access denied',
                    'data' => ['Error'=>$ex->getMessage()]
                ];
            }         

        }
        return $this->respondCreated($response);
    }

    
 //get Polls
 public function getPolls(){    
        
        // $key = $this->getKey();
        // $authHeader = $this->request->getHeader("Authorization");
        // $authHeader = $authHeader->getValue();
        //  $token = $authHeader;
        try {
             // $decoded = JWT::decode($token, $key, array("HS256"));
            // if ($decoded){
               $UserId=$this->request->getVar('UserId');  
               $ConstituencyID=$this->request->getVar('ConstituencyID'); 
               $Poll_details=$this->ApiModel->getPolls($UserId);    
               $test=$this->ApiModel->getPolls($UserId); 
              // print_r($test); 
               foreach($Poll_details as $row){
                    $p_id[]=$row['pr_p_id'];  
                } 

                if(isset($p_id)){
                    $Poll_detailss= $this->ApiModel->getPollsById($p_id);       
                   // print_r($Poll_detailss);   
                   $i=0;
                   foreach($Poll_detailss as $row){
                           $Poll_detailss[$i]['pr_response']="";
                       $i++;
                   }
                }else{
                    $Poll_detailss="";                   
                    //$Poll_detailss=$this->ApiModel->getWhereQuery('poll',$where_parameter);
                    $parameters="*";
                    $order_by="p_id";
                    //$Poll_detailss=$this->AdminModel->getQueryFrom('poll',$parameters,$order_by);
                    $where_parameter=["PollsStatus"=>"Publish"]; 
                    $Poll_detailss=$this->ApiModel->getQueryFromTableAsc('poll',$parameters,$where_parameter,$order_by,"desc"); 
                    //print_r($Poll_detailss);    
                    $i=0;
                    foreach($Poll_detailss as $row){
                            $Poll_detailss[$i]['pr_response']="";
                        $i++;
                    }
                      
                } 
              // exit();
             $test1= array_merge($Poll_detailss,$test);

            $total = array();
            foreach ($test1 as $key => $row)
            {
                $total[$key] = $row['p_id'];
            }
            array_multisort($total, SORT_DESC, $test1);
            
            //latest polls get forusers
            $test=$this->ApiModel->getPollsByUsers($UserId);  


              $response = [
                    'status' => 200, 
                    "error" => false,
                    'messages' => 'Successfully Get Polls details',
                    'data' =>[
                            "Polls"=>$Poll_detailss,
                         //   "SubmitedPollsss"=>$test,
                            "MergeResults"=>$test1,
                          //  "latestPolls"=>$test
                        ]
                ];
            
            // }
        }catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage()]
            ];
        } 
    return $this->respondCreated($response);
}

//add Polls response
public function Pollresponse(){        
    $rules = [
        "u_id" => "required",
        "response" => "required",
        "p_id" => "required"
        
    ];
    $messages = [
        "u_id" => [
            "required" => "User Id is required"
        ],
        "response" => [
            "required" => "response is required"
        ],
        "p_id" => [
            "required" => "Polls Id required"

        ],
    ];
    if (!$this->validate($rules, $messages)) { 
        $response = [
            'status' => 500,
            'error' => true,
            'message' => $this->validator->getErrors(),
            'data' => []
        ];
    } else {  
        $table_data = [
        "pr_u_id" => $this->request->getVar("u_id"),
        "pr_response" => $this->request->getVar("response",FILTER_SANITIZE_STRING),
        "pr_p_id" => $this->request->getVar("p_id")
        ];
            $table="poll_responses";
            $record_inserted_id=$this->ApiModel->insert_record($table,$table_data);
        if ($record_inserted_id) {  
        //  $record_inserted_id=$this->ApiModel->insert_record($table,$table_data);
            $response = [
                'status' => 200,
                "error" => false,
                'messages' => 'Your Response Successfully Submitted',
                'data' => []

                        
            ];
        } else {
            $response = [
                'status' => 500,
                "error" => true,
                'messages' => 'Failed to add polls response',
                'data' => []
            ];
        }
    }
    return $this->respondCreated($response);
}

//Views Check function 
public function CheckView(){ 
   
    $rules = [
        "UserId" => "required",
        "ViewFrom" => "required",
        "ViewFromId" => "required"
        
    ];
    $messages = [
        "UserId" => [
            "required" => "User Id is required"
        ],
        "ViewFrom" => [
            "required" => "ViewFrom is required"
        ],
        "ViewFromId" => [
            "required" => "ViewFromId Id required"

        ],
    ];
    if (!$this->validate($rules, $messages)) { 
        $response = [
            'status' => 500,
            'error' => true,
            'message' => $this->validator->getErrors(),
            'data' => []
        ];
    } else { 
                // $key = $this->getKey();
                // $authHeader = $this->request->getHeader("Authorization");
                // $authHeader = $authHeader->getValue();
                //  $token = $authHeader;

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $table_data=[
                        "UserId"=>$this->request->getVar("UserId"), 
                        "ViewFrom"=>$this->request->getVar("ViewFrom"),
                        "ViewFromId"=>$this->request->getVar("ViewFromId"),
                    ];
                    $result=$this->AdminModel->insertIgnore('ViewsCheck',$table_data); 
                    if($result){
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Successfully Update',
                            'data' => []
                        ];
                    }else{
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Unable to Update',
                            'data' => []
                        ];
                    }
                //}
        } catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine()]
            ];
        }
    }
     return $this->respondCreated($response); 
 }

 //Views Check function 
public function ShareDetails(){    
    $rules = [
        "UserId" => "required",
        "SharedFrom" => "required",
        "SharedFromId" => "required"
        
    ];
    $messages = [
        "UserId" => [
            "required" => "User Id is required"
        ],
        "SharedFrom" => [
            "required" => "ViewFrom is required"
        ],
        "SharedFromId" => [
            "required" => "ViewFromId Id required"

        ],
    ];
    if (!$this->validate($rules, $messages)) { 
        $response = [
            'status' => 500,
            'error' => true,
            'message' => $this->validator->getErrors(),
            'data' => []
        ];
    } else { 
                // $key = $this->getKey();
                // $authHeader = $this->request->getHeader("Authorization");
                // $authHeader = $authHeader->getValue();
                //  $token = $authHeader;

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $table_data=[
                        "UserId"=>$this->request->getVar("UserId"), 
                        "SharedFrom"=>$this->request->getVar("SharedFrom"),
                        "SharedFromId"=>$this->request->getVar("SharedFromId"),
                        "SharedPlatform"=>$this->request->getVar("SharedPlatform"), 
                        "Points"=>10
                    ];
                    $result=$this->AdminModel->insertSharedDetails('ShareDetails',$table_data,$this->request->getVar("UserId"),10); 
                    if($result){
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Successfully Update',
                            'data' => []
                        ];
                    }else{
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Unable to Update',
                            'data' => []
                        ];
                    }
                //}
        } catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine()]
            ];
        }
    }
     return $this->respondCreated($response); 
 }

public function getDashboardDetails(){
    $rules = [
        "UserId" => "required",
        "ConstituencyId" => "required" 
        
    ];
    $messages = [
        "UserId" => [
            "required" => "User Id is required"
        ],
        "ConstituencyId" => [
            "required" => "ConstituencyId is required"
        ],
    ];
    if (!$this->validate($rules, $messages)) { 
        $response = [
            'status' => 500,
            'error' => true,
            'message' => $this->validator->getErrors(),
            'data' => []
        ];
    } else { 
                // $key = $this->getKey();
                // $authHeader = $this->request->getHeader("Authorization");
                // $authHeader = $authHeader->getValue();
                //  $token = $authHeader;

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){

                    //get Comaping summery
                    $UserId=$this->request->getVar("UserId");
                    $ConstituencyId=$this->request->getVar("ConstituencyId");
                    $compaingResult=$this->ApiModel->getCompaingCountByUserId($UserId); 
                    $Completed=0;
                    $Open=0;
                    foreach($compaingResult as $row){
                        if($row['Activity_status']=="Open"){
                            $Open=$row["total"];
                        }else{
                            $Completed=$row["total"];
                        }
                    }
                     $total=$Open+$Completed;
                    if($Completed == 0){
                        $total_percentage=0;
                    }else{
                        $total_percentage=round($Completed/$total*100,2);
                    }
                   
                    if($Open == 0){ 
                        $ActionRequired_percentage=0;
                    }else{
                        $ActionRequired_percentage=round($Open/$total*100,2);
                    }
                  

                    $compaingResultDetails=["Total"=>$Open+$Completed,"Completed"=>$Completed,"ActionRequired"=>$Open,"total_percentage"=>$total_percentage,"ActionRequired_percentage"=>$ActionRequired_percentage];

                    // get polls
                    $getPollsTotal=$this->ApiModel->getPollsTotal();
                    $getPollsResponseTotal=$this->ApiModel->getPollsResponseTotal($UserId);   

                   // $comPersntage=round($getPollsResponseTotal/$getPollsTotal*100,2);
                    $ActionRequired=$getPollsTotal-$getPollsResponseTotal;
                   $total_percentage=round($getPollsResponseTotal/$getPollsTotal*100,2);
                 
                   if($getPollsTotal == 0){
                       //  $ActionRequired_percentage=0;
                   }else{
                      $ActionRequired_percentage=round($ActionRequired/$getPollsTotal*100,2);
                   }
               

                    $pollDetails=["TotalPolls"=>$getPollsTotal,"Completed"=>$getPollsResponseTotal,"ActionRequired"=>$getPollsTotal-$getPollsResponseTotal,"total_percentage"=>$total_percentage,"ActionRequired_percentage"=>$ActionRequired_percentage];




                    //sm task
                    $SelectedGroups=$this->request->getVar('SelectedGroups'); 
                    $group_ids= explode(",",$SelectedGroups);
                      $taskdetails=$this->ApiModel->getCountTasksByGroupIds($SelectedGroups,$group_ids); 
                   // exit();
                    //my constiuency
                
                      $getSharedSmTasks=$this->ApiModel->getSharedSmMobileDashTasks($UserId);    
                 

                    $ActionRequired=$taskdetails-$getSharedSmTasks;
                    $total_percentage=round($getSharedSmTasks/$taskdetails*100,2);



                    $ActionRequired_percentage=round($ActionRequired/$taskdetails*100,2);

                    $mySocialMediaTasksDetails=["TotalTasks"=>$taskdetails,"Completed"=>$getSharedSmTasks,"ActionRequired"=>$taskdetails-$getSharedSmTasks,"total_percentage"=>$total_percentage,"ActionRequired_percentage"=>$ActionRequired_percentage];

                    //constituency social media members
                    $where_data=["ConstituencyId"=>$ConstituencyId];
                    $totalSocialmediaMembers=$this->AdminModel->tableRowsCount('users',$where_data);   

                    //total user share count constitunecey
                    $getConstituencySharedCount=$this->ApiModel->getConstituencySharedCount($ConstituencyId);    

                    //get point his constituency
                    $getConstituencyPointsCount=$this->ApiModel->getConstituencyPointsCount($ConstituencyId); 
                    $getConstituencyPointsCount=$getConstituencyPointsCount['total_points'];
                    
                    $getRankInsate=$this->ApiModel->getRankInsate();
                    //print_r($getConstituencyPointsCount);
                    $Rank=0;
                    foreach($getRankInsate as $row){
                        if($row['userId'] == $UserId){
                            $Rank=$row['rank_no'];
                        }
                    }
                    $constituencySocialMedia=["totalSocialmediaMembers"=>$totalSocialmediaMembers,"getConstituencySharedCount"=>$getConstituencySharedCount,"getConstituencyPointsCount"=>$getConstituencyPointsCount,"Rank"=>$Rank];
                   // exit();
                    $response = [
                        'status' => 500,
                        'error' => true,
                        'messages' => 'Successfully get Dashboaerd details',
                        'data' => [
                            'compaingResult'=>$compaingResultDetails,
                            "pollDetails"=>$pollDetails,
                            "mySocialMediaTasksDetails"=>$mySocialMediaTasksDetails,
                            "constituencySocialMedia"=>$constituencySocialMedia
                        
                        ]
                    ];

                //}
        } catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine()]
            ];
        }
    }
     return $this->respondCreated($response); 
}

//get my constituency 
public function getUsersByConstituencyIdPoints(){
    $rules = [
        "ConstituencyId" => "required"
        
    ];
    $messages = [
        "ConstituencyId" => [
            "required" => "Constituency Id is required"
        ]
    ];
    if (!$this->validate($rules, $messages)) { 
        $response = [
            'status' => 500,
            'error' => true,
            'message' => $this->validator->getErrors(),
            'data' => []
        ];
    } else { 
                // $key = $this->getKey();
                // $authHeader = $this->request->getHeader("Authorization");
                // $authHeader = $authHeader->getValue();
                //  $token = $authHeader;

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $ConstituencyId=$this->request->getVar("ConstituencyId");
                    // $table_data=[
                    //     "UserId"=>$this->request->getVar("UserId"), 
                    //     "SharedFrom"=>$this->request->getVar("SharedFrom"),
                    //     "SharedFromId"=>$this->request->getVar("SharedFromId"),
                    //     "SharedPlatform"=>$this->request->getVar("SharedPlatform"), 
                    //     "Points"=>10
                    // ];
                    // $result=$this->AdminModel->insertSharedDetails('ShareDetails',$table_data,$this->request->getVar("UserId"),10); 
                    $result=$this->ApiModel->getUsersByConstituencyIdPoints($ConstituencyId);
                    $i=0;
                    foreach($result as $row){
                        $result[$i]['sharecount']=$this->ApiModel->getConstituencySharedCountByUser($row['u_id']);   
                        $i++;
                    }
                    $img_path=base_url()."/uploads/user_profile/";
                    if($result){
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Successfully Constituency',
                            'data' => ["users"=>$result,
                                        "img_path"=>$img_path
                            ]
                        ];
                    }else{
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Unable to Update',
                            'data' => []
                        ];
                    }
                //}
        } catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine()]
            ];
        }
    }
     return $this->respondCreated($response);
}

//get constincy wise share points
public function getConstituencySharesPoints(){
   
                // $key = $this->getKey();
                // $authHeader = $this->request->getHeader("Authorization");
                // $authHeader = $authHeader->getValue();
                //  $token = $authHeader;

            try {
                // $decoded = JWT::decode($token, $key, array("HS256"));
                // if ($decoded){
                    $ConstituencyId=$this->request->getVar("ConstituencyId");
                    // $table_data=[
                    //     "UserId"=>$this->request->getVar("UserId"), 
                    //     "SharedFrom"=>$this->request->getVar("SharedFrom"),
                    //     "SharedFromId"=>$this->request->getVar("SharedFromId"),
                    //     "SharedPlatform"=>$this->request->getVar("SharedPlatform"), 
                    //     "Points"=>10
                    // ];
                    // $result=$this->AdminModel->insertSharedDetails('ShareDetails',$table_data,$this->request->getVar("UserId"),10); 
                    $result=$this->ApiModel->getConstituencyIdPointsShares();
                    // print_r($result);
                    // exit();
                    // $i=0;
                    // foreach($result as $row){
                    //     $result[$i]['sharecount']=$this->ApiModel->getConstituencySharedCountByUser($row['u_id']);   
                    //     $i++;
                    // }
                    // $img_path=base_url()."/uploads/user_profile/";
                    if($result){
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Successfully Constituency',
                            'data' => ["users"=>$result ]
                        ];
                    }else{
                        $response = [
                            'status' => 500,
                            "error" => true,
                            'messages' => 'Unable to Update',
                            'data' => []
                        ];
                    }
                //}
        } catch (Exception $ex) {          
            $response = [
                'status' => 401,
                'error' => true,
                'messages' => 'Access denied',
                'data' => ['Error'=>$ex->getMessage(),'line'=>$ex->getLine()]
            ];
        }
    
     return $this->respondCreated($response);
}

 

}
