<?php 
	namespace App\Models;
	use \CodeIgniter\Model;
	
	class Admin_model extends Model {		
		function __construct()
		{
			// Construct the parent class
			parent::__construct();
			$db = \Config\Database::connect();
		} 

        function insert_record($table,$table_data)
		{
			$builder=$this->db->table($table);
		    $res=$builder->insert($table_data);
			return $this->db->insertID();
		}

			//yellow code here to start
		public function getQueryFromTable($table,$parameters,$order_by){ 
			$builder = $this->db->table($table); 
			$builder->select($parameters);
			$builder->where('IsActive','1');			
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		//admin quries grid
		public function getQueryFromTableAdmins($table,$parameters,$order_by){ 
			$builder = $this->db->table($table); 
			$builder->select($parameters);		
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		public function getQueryFromTableAsc($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);
			//$builder->where('IsActive','1');			
			$builder->orderBy($order_by,'asc');
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryReultFromTable($table,$where){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			$builder->where($where);	
			return $query = $builder->get()->getResultArray();;
		}
		//get all details from details 
		public function getTable($table){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryReultFromTables($table,$where){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			$builder->where($where);
			$builder->orderBy('u_id','desc');	
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryData(){ 
			$query =$this->db->query("SELECT * FROM users order by u_id desc");
			return $query->getResultArray(); 
		}

		public function programActivityGrid(){  
			//return $query = $db->query("SELECT * FROM users;");
			 $query = $this->db->query("select activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.IsActive,activity.CreatedDate,activity.ActivityId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) group by activity.ActivityId order by activity.ActivityId desc");
			 return $query->getResultArray();
		}

		public function programActvityForExecutiveDash(){
			$query = $this->db->query("select  SUM(activitystatus.CheckView) as ToatalView,COUNT(activitystatus.ActivityStatuId) as ToatalRecords,activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId from activity join activitystatus on activitystatus.ActivityId=activity.ActivityId group by activity.ActivityId order by activity.ActivityId desc");
			return $query->getResultArray();
		}
		//app users program activity
		public function userProgramActivityGrid($id){ 
			//return $query = $db->query("SELECT * FROM users;");
			 $query = $this->db->query("select constituency.ConstituencyName,activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId,users.DisplayName,users.FirstName,users.Mobile,activitystatus.ActivityId,activitystatus.Activity_status as k,activitystatus.UpdatedDate,activitystatus.ActivityStatuId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity  join activitystatus on activitystatus.ActivityId=activity.ActivityId join users on users.u_id=activitystatus.UserId join constituency on constituency.ConstituencyID=users.ConstituencyId join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) where activitystatus.ActivityId='".$id."'  group by users.u_id,activitystatus.ActivityId");
			 return $query->getResultArray();
		}

		//app users program activity
		public function userProgramActivityCountByStatus($id,$where){ 
			//return $query = $db->query("SELECT * FROM users;");
			 $query = $this->db->query("select activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId,users.FirstName,users.Mobile,activitystatus.ActivityId,activitystatus.Activity_status as k,activitystatus.UpdatedDate,activitystatus.ActivityStatuId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity  join activitystatus on activitystatus.ActivityId=activity.ActivityId join users on users.u_id=activitystatus.UserId join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) where activitystatus.ActivityId='".$id."' and activitystatus.Activity_status='".$where."'  group by users.u_id,activitystatus.ActivityId");
			 return count($query->getResultArray());	
			// return $builder->countAllResults();
		}

		//get app users data
		public function appUserGrid(){
			$query = $this->db->query("select users.FirstName,users.Mobile,users.Email,activity.ActivityStatus,Status.TargetCompletionDate,activity.CreatedDate,activity.ActivityId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) group by activity.ActivityId");
			 return $query->getResultArray();
		}
		public function getRowTableById($table,$where_parameter,$where_id){
			//$db = \Config\Database::connect();
			$builder=$this->db->table($table); 
			$builder->select('*');      
			$builder->where($where_parameter,$where_id);
			return $query = $builder->get()->getRowArray(); 
			// return $db->getLastQuery();
		}

		public function getRowTableByUserId($table,$where_parameter,$where_id){
			$builder=$this->db->table('users');
            $builder->select('*'); 
            $builder->join('approles', 'approles.AppRoleId = users.AppRoleId');  
			$builder->where('users.u_id',$where_id);  
            return $query = $builder->get()->getRowArray(); 
		}

		public function updateQuery($table,$table_data,$where_parameter,$where_id){		 	
			$builder=$this->db->table($table); 
			$builder->where($where_parameter,$where_id);
			$builder->update($table_data);
			//return	$this->db->getLastQuery();
			return $affected_rows = $this->db->affectedRows();
		}

		//get mandals
		public function getMandalsByConstituency($s){ 
			$builder=$this->db->table('mandals');
            $builder->select('*'); 
            $builder->join('constituency', 'constituency.ConstituencyID = mandals.constituency_id'); 
			$builder->join('parliament', 'parliament.ParliamentID = constituency.ParliamentID'); 
			$builder->where('parliament.ParliamentID',$s);  
            return $query = $builder->get()->getResultArray(); 
		} 

		//get villages 
		public function getMandalsByvillage($s){
			$builder=$this->db->table('mandals');
            $builder->select('*'); 
            $builder->join('constituency', 'constituency.ConstituencyID = mandals.constituency_id'); 
			$builder->join('parliament', 'parliament.ParliamentID = constituency.ParliamentID'); 
			$builder->join('villages', 'villages.mandal_id = mandals.mandal_id'); 
			$builder->where('parliament.ParliamentID',$s);  
            return $query = $builder->get()->getResultArray(); 
		}
		//getUsersByGroupdIds
		public function getUsersByGroupdIds($row){
			$query = $this->db->query("SELECT u_id,ActivityCommitteeGroup FROM users where FIND_IN_SET('".$row."',ActivityCommitteeGroup)");
			 return $query->getResultArray();
		}

		//userProgramCampainingById
		public function userProgramCampainingById($id){
			$builder=$this->db->table('activitystatus');
            $builder->select('activitystatus.*,users.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource,activity.AssignedGroupsId'); 
            $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
            $builder->join('users', 'users.u_id = activitystatus.userId');  
			$builder->where('activitystatus.ActivityStatuId',$id);  
            return $query = $builder->get()->getRowArray(); 
		}

		//table rows count 
		public function tableRowsCount($table,$where_data){ 
			$builder=$this->db->table($table);
            $builder->select('*'); 
			$builder->where($where_data);
			return $builder->countAllResults();
			//return $this->db->getLastQuery();
		}

		//get tasks
		public function getTasks(){
			$builder=$this->db->table('tasks');
            $builder->select('*,tasks.IsActive as TsIsActive'); 
            $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
			$builder->orderBy('tasks.TaskId','desc');	
            return $query = $builder->get()->getResultArray(); 
		}

		//get Cadre Listening
		public function getCadreListeningGrid(){
			$builder=$this->db->table('cadrelisteningdetails');
            $builder->select('*,cadrelisteningdetails.IsActive as CdIsActive'); 
            $builder->join('parliament', 'parliament.ParliamentID = cadrelisteningdetails.ParliamentId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = cadrelisteningdetails.ConstituencyId'); 
			$builder->orderBy('cadrelisteningdetails.CadreListeningId','desc');	 
            return $query = $builder->get()->getResultArray(); 
		}

		//admin approve user activity
		public function updateQueryPointsDetails($ActivityStatuId,$userId,$ActivityId){
			$data = [
				'PointStatus' =>'Approved', 
			];
			$builder=$this->db->table('pointsdetails');
			$builder->where('PointFromId',$ActivityStatuId);
			$builder->where('userId',$userId);
			$builder->update($data);

			$query = $this->db->query('SELECT SUM(Points) AS total FROM pointsdetails WHERE PointFromId="'.$ActivityStatuId.'" and userId="'.$userId.'"');
			$result_data= $query->getRowArray();

			$total= $result_data['total'];
			if($total){
				$where_parameter="UserId";
				$where_id=$userId;
				$userPoints=$this->getRowTableById('points',$where_parameter,$where_id);
				if($userPoints){
					$query=$this->db->query("UPDATE points SET Points=Points+'".$total."' WHERE UserId='".$userId."'"); 
					$table_data1=['UsersActivityStatus'=>"Approved"];
					$this->updateQuery('activity',$table_data1,'ActivityId',$ActivityId);

					$result="success";
				}else{
				
					$table_data=['UserId'=>$userId,"Points"=>$total];
					$this->insert_record('points',$table_data);

					$table_data1=['UsersActivityStatus'=>"Approved"];
					$this->updateQuery('activity',$table_data1,'ActivityId',$ActivityId);

					$result="success";
				}
				return $result;
			}
		}


		//public function check parliments insert or nont
		public function checkParliament($parliamentName){
				$where_data=['ParliamentName'=>$parliamentName];
				$ParliamentNameCount=$this->tableRowsCount('parliament',$where_data);
				if($ParliamentNameCount){
					$where_parameter="ParliamentName";
					$where_id=$parliamentName;
					$result=$this->getRowTableById('parliament',$where_parameter,$where_id);
					return $result['ParliamentID']; 
				}else{
					$table_data=["ParliamentName"=>$parliamentName];
					return $this->insert_record('parliament',$table_data);
				}
		}

		//constituency insert 
		public function InsertConstituency($ConstituencyData){
			$builder=$this->db->table('constituency');
			return $builder->insertBatch($ConstituencyData);
		}

		//insert child data
		public function InsertChildData($InsertData){
			$builder=$this->db->table('child_campaign');
			return $builder->insertBatch($InsertData);
		}

		//insert marks
		public function InsertMarksData($InsertData){
			$builder=$this->db->table('marks');
			return $builder->insertBatch($InsertData);
		}

		//insert Grade
		public function InsertImportData($table,$InsertData){
			$builder=$this->db->table($table);
			return $builder->insertBatch($InsertData);
		}

		public function getProfileDetails($u_id){ 
			$builder=$this->db->table('users');
            $builder->select('*'); 
            $builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->where('users.u_id',$u_id);  
            return $query = $builder->get()->getRowArray(); 
		}

		//public function 

		public function programConductedNotConducted($compain_id){ 
			$query = $this->db->query('SELECT parent_campaign_id,campaign_conducted, COUNT(*) as total FROM child_campaign WHERE parent_campaign_id="'.$compain_id.'" GROUP BY campaign_conducted');
			return $result_data= $query->getResultArray();
		}

		//program Conducted Not Conducted By Compain_id
		public function programConductedNotConductedByCompain_id($compain_id){  
			$query = $this->db->query('SELECT ActivityStatuId,ConstituencyProgramConducted, COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted !="" GROUP BY ConstituencyProgramConducted');
			return $result_data= $query->getResultArray();
		}

		public function constituencySubmitedData($compain_id){  
			$query = $this->db->query('SELECT *,users.*,constituency.ConstituencyName FROM activitystatus JOIN users ON users.u_id=activitystatus.UserId JOIN constituency ON constituency.ConstituencyID=users.ConstituencyId WHERE Activity_status="Completed" and ActivityId="'.$compain_id.'" ORDER BY CompletedDate DESC LIMIT 5');
			return $result_data= $query->getResultArray();
		}

		//get data
		public function inchargeParticipatedNotParticipated($compain_id){
			$query = $this->db->query('SELECT Remarks,Mla_Incharge_Participation, COUNT(*) as total FROM child_campaign WHERE Mla_Incharge_Participation IN("YES","NO") and parent_campaign_id="'.$compain_id.'" GROUP BY Mla_Incharge_Participation');
			return $result_data= $query->getResultArray(); 
		}

		public function inchargeParticipatedNotParticipatedByCompain_id($compain_id){
			$query = $this->db->query('SELECT ActivityStatuId,MlaInchargeParticipation, COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'" and MlaInchargeParticipation !="" GROUP BY MlaInchargeParticipation');
			return $result_data= $query->getResultArray();
		}

		public function CompaingViwedOrNot($compain_id){
			$query = $this->db->query('SELECT CheckView,COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'"  GROUP BY CheckView');
			return $result_data= $query->getResultArray();
		}

		//get Overall Report
		public function ParticipatedAssemblyConstituencies($compain_id){
			$query = $this->db->query('SELECT ConstituencyProgramConducted,COUNT(ConstituencyProgramConducted) as Ac_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"    GROUP BY ActivityId');
			return $result_data= $query->getRowArray();
		}
		//PP Count
		public function PPCount($compain_id){
			$query = $this->db->query('SELECT SUM(NoOfCadreParticipatedCount) as CPC_count,SUM(NeutralPeopleParticipatedCount) as NPC_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"  GROUP BY ActivityId');
			return $result_data= $query->getRowArray();
		}

		//public function 
		public function GradingCount($compain_id){
			$query = $this->db->query('SELECT grade,Count(*) as percentage_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"  GROUP BY grade');
			return $result_data= $query->getResultArray();
		}

		public function NonPCNames($compain_id){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.ConstituencyProgramConducted','No');  
			$builder->groupBy("constituency.ConstituencyID");
			//$builder->groupBy(["constituency.ConstituencyID", "date"]);
            return $query = $builder->get()->getResultArray(); 
		}

		//mal incharge count

		public function compainOrderbyDesc(){
			$query = $this->db->query('SELECT * FROM activity ORDER BY ActivityId DESC LIMIT 1');
			return $result_data= $query->getRowArray();
		}
   
		//yellow code here to start
		public function getQueryFrom($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);			
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		//yellow code here to start
		public function getQueryFromPolls($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);	
			$builder->where('PollsStatus','Publish');		
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}

		//get Grading By Compaing Id($compain_id)
		public function getGradingByCompaingId($compain_id){ 
			$query = $this->db->query("select  grade,SUM(activitystatus.Marks) as ToatalMarks,COUNT(activitystatus.ActivityStatuId) as ToatalRecords,activitystatus.ActivityId from activitystatus where grade!='' and ActivityId='".$compain_id."' group by activitystatus.Grade");
			return $query->getResultArray(); 
		}

		public function getConstencyParliments($compain_id,$grade){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.Grade',$grade); 
			$builder->groupBy("constituency.ConstituencyID");
			//$builder->groupBy(["constituency.ConstituencyID", "date"]);
            return $query = $builder->get()->getResultArray(); 
		}

		public function getConstencyParlimentsForIncharges($compain_id,$incharge){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.MlaInchargeParticipation',$incharge); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		}

		public function getConstencyParlimentsForViewd($compain_id,$checkView){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.CheckView',$checkView); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		}

		public function getConstencyParlimentsForPP($compain_id,$ConstituencyProgramConducted){ 
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.ConstituencyProgramConducted',$ConstituencyProgramConducted); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		} 
		//table rows count 
		public function tableRowsCountpoll($table){ 
			$builder=$this->db->table($table);
            $builder->select('*'); 
            $builder->groupBy('pr_u_id');
			return $builder->countAllResults();
		}
		public function pollresponse($id){
			$builder=$this->db->table('poll_responses');
            $builder->select('*'); 
            $builder->join('poll','poll.p_id = poll_responses.pr_p_id');
            $builder->join('users','users.u_id = poll_responses.pr_u_id');  
			$builder->where('poll_responses.pr_p_id',$id);  
            return $query = $builder->get()->getResultArray(); 
		}

		//iInsert Ignore
		public function insertIgnore($table,$table_data){ 
			if($this->tableRowsCount($table,$table_data)){

			}else{
				
				$builder=$this->db->table($table);
				$builder->ignore(true)->insert($table_data);
				return $this->db->insertID();
			}
		}

		//shared details
		public function insertSharedDetails($table,$table_data,$userId,$total){
			$builder=$this->db->table($table);
			$builder->ignore(true)->insert($table_data);
			$result=$this->db->insertID();
			if($result){
				$table_data=["UserId"=>$userId];
				if($this->tableRowsCount('points',$table_data)){					
					$query=$this->db->query("UPDATE points SET Points=Points+'".$total."' WHERE UserId='".$userId."'"); 
				}else{
					$table_data=["UserId"=>$userId,"Points"=>$total];
					$this->insert_record('points',$table_data);
				}
			}
			return $result; 
		}

		
		
    }
