<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Trips_model extends CI_Model{
	public function add_trips($data) {   
		unset($data['bookingemail']);
		$insertdata = $data;
		$insertdata['t_trackingcode'] = uniqid();
		$this->db->insert('trips',$insertdata);
		//echo $this->db->last_query();
		return $this->db->insert_id();
	} 
	public function getall_customer() { 
		return $this->db->select('*')->from('customers')->order_by('c_name','asc')->get()->result_array();
	} 
	public function getall_vechicle() { 
		$organization_id=$this->session->userdata['session_data']['organization_id'];
		$this->db->select("*");
		$this->db->from('vehicles');
		$this->db->join('drivers', 'drivers.d_id=vehicles.v_driver_id');
		$this->db->where('drivers.organization_id',$organization_id);
		$query = $this->db->get();
		return $query->result_array();

		//return $this->db->select('*')->from('vehicles')->get()->result_array();
	} 
	public function getall_mybookings($c_id) { 
		return $this->db->select('*')->from('trips')->where('t_customer_id',$c_id)->order_by('t_id','asc')->get()->result_array();
	}
	public function getall_driverlist() { 
		return $this->db->select('*')->from('drivers')->get()->result_array();
	}
	public function getall_trips_expense($t_id) { 
		return $this->db->select('*')->from('trips_expense')->where('e_trip_id',$t_id)->get()->result_array();
	} 
	public function get_paymentdetails($t_id) { 
		return $this->db->select('*')->from('trip_payments')->where('tp_trip_id',$t_id)->get()->result_array();
	}
	
	public function getall_trips($trackingcode=false) { 
		$newtripdata = array();
		$organization_id=$this->session->userdata['session_data']['organization_id'];
		if($trackingcode) {
			$tripdata = $this->db->select('*')->from('trips')->where('t_trackingcode',$trackingcode)->order_by('t_id','desc')->get()->result_array();
		} else { 
			$this->db->select("*");
			$this->db->from('trips');
			$this->db->join('drivers', 'drivers.d_id=trips.t_driver');			
			$this->db->where('drivers.organization_id',$organization_id);
			$this->db->where_not_in('trips.t_trip_status','session_out'); 
			$this->db->order_by("trips.t_id", "desc");
			$query = $this->db->get();
			$tripdata= $query->result_array();
		}
		if(!empty($tripdata)) {
			foreach ($tripdata as $key => $tripdataval) {
				$newtripdata[$key] = $tripdataval;
				$newtripdata[$key]['t_customer_details'] =  $this->db->select('*')->from('customers')->where('c_id',$tripdataval['t_customer_id'])->get()->row();
				$newtripdata[$key]['t_vechicle_details'] =  $this->db->select('*')->from('vehicles')->where('v_id',$tripdataval['t_vechicle'])->get()->row();
				$newtripdata[$key]['t_driver_details'] =   $this->db->select('*')->from('drivers')->where('d_id',$tripdataval['t_driver'])->get()->row();
			}
			return $newtripdata;
		} else 
		{
			return false;
		}
	}
	public function getaddress($lat,$lng)
	{
		$google_api_key = $this->config->item('google_api_key'); 
		$url = 'https://maps.googleapis.com/maps/api/geocode/json?key='.$google_api_key.'&latlng='.trim($lat).','.trim($lng).'&sensor=false';
		$json = @file_get_contents($url);
		$data = json_decode($json);
		if (!empty($data)) {
			$status = $data->status;
			if ($status == "OK") {
				return $data->results[1]->formatted_address;
			} else {
				return false;
			}
		} else {
			return '';
		}
	}
	public function get_tripdetails($t_id) { 
		return $this->db->select('*')->from('trips')->where('t_id',$t_id)->get()->result_array();
	} 
	public function update_trips($data) { 
		$this->db->where('t_id',$this->input->post('t_id'));
		$this->db->update('trips',$data);
		return $this->input->post('t_id');
	}
		/* 
	public function trip_reports($from,$to,$v_id) { 
		$newtripdata = array();
		if($v_id=='all') {
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to);
		} else {
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to,'t_vechicle'=>$v_id);
		}
		
		$tripdata = $this->db->select('*')->from('trips')->where($where)->order_by('t_id','desc')->get()->result_array();
		if(!empty($tripdata)) {
			foreach ($tripdata as $key => $tripdataval) {
				$newtripdata[$key] = $tripdataval;
				$newtripdata[$key]['t_customer_details'] =  $this->db->select('*')->from('customers')->where('c_id',$tripdataval['t_customer_id'])->get()->row();
				$newtripdata[$key]['t_vechicle_details'] =  $this->db->select('*')->from('vehicles')->where('v_id',$tripdataval['t_vechicle'])->get()->row();
				$newtripdata[$key]['t_driver_details'] =   $this->db->select('*')->from('drivers')->where('d_id',$tripdataval['t_driver'])->get()->row();
			}
			return $newtripdata;
		} else 
		{
			return array();
		}
	} */
	public function organization_reports($from,$to,$org_id) { 
		
		$newtripdata = array();
		if($org_id=='all') {
			$where1 = array('organization_id>='=>$org_id);
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to);
		} else {
			$data = $this->db->select('d_id')->from('drivers')->join('organization','organization.org_id=drivers.organization_id')->where('drivers.organization_id',$org_id)->get()->result_array();
    // $arrayName[] = array();
			foreach($data as $d) {
				$arrayName[] = $d['d_id'];
   // $arrayName++;
    # code...
			}
// $stringRepresentation= json_encode($arrayName);
			$str = implode(',', $arrayName);
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to,'t_driver<='=>$str);
                       // $we=array('t_driver',$str);

			$where1 = array('organization_id>='=>$org_id);

		}
		
		// $tripdata= $this->db->select('*,sum(trips.t_trip_amount) + sum(trips.t_waiting_amount) AS total_amount')->from('trips')->join('drivers', 'drivers.d_id = trips.t_driver')->join('organization', 'organization.org_id = drivers.organization_id')->where($where)->order_by('t_id','desc')->get()->result_array();

		if($org_id=='all') {
			$tripdata= $this->db->select('*,sum(trips.t_trip_amount) + sum(trips.t_waiting_amount) AS total_amount')->from('organization')->join('drivers', 'drivers.d_id = organization.org_id')->join('trips', 'trips.t_driver = drivers.d_id')->get()->result_array();
		}else{
			$tripdata= $this->db->select('*,sum(trips.t_trip_amount) + sum(trips.t_waiting_amount) AS total_amount')->from('organization')->join('drivers', 'drivers.d_id = organization.org_id')->join('trips', 'trips.t_driver = drivers.d_id')->where($where)->get()->result_array();
		}		
		if(!empty($tripdata)) {
			foreach ($tripdata as $key => $tripdataval) {
				$newtripdata[$key] = $tripdataval;
				if($org_id=='all'){

					$newtripdata[$key]['drivers']= $this->db->select('*')->from('drivers')->get()->num_rows();
				}
				else{
					$newtripdata[$key]['drivers']= $this->db->select('*')->from('organization')->join('drivers', 'drivers.organization_id = organization.org_id')->where('organization.org_id',$org_id)->get()->num_rows();
				}
				if($org_id=='all'){

					$newtripdata[$key]['ty'] =   $this->db->select('*')->from('trips')->where($where)->group_by('t_id')->get()->num_rows();
				}else{
					$newtripdata[$key]['ty'] =   $this->db->select('*')->from('trips')->where($where)->group_by('t_id')->get()->num_rows();

				}
			}
			return $newtripdata;
		} else 
		{
			return array();
		}
	} 
	public function trip_reports($from,$to,$v_id) { 
		$organization_id=$this->session->userdata['session_data']['organization_id'];
		$newtripdata = array();
		if($v_id=='all') {
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to);
		}
		else {
			$where = array('t_start_date>='=>$from,'t_start_date<='=>$to,'t_vechicle'=>$v_id);
		}
		if($organization_id != "0"){
			$this->db->select("*");
			$this->db->from('trips');
			$this->db->join('drivers', 'drivers.d_id=trips.t_driver');
			$this->db->join('vehicles', 'vehicles.v_id=trips.t_vechicle');
			$this->db->join('vehicle_group', 'vehicle_group.gr_id=vehicles.v_group','LEFT');	
			$this->db->where('drivers.organization_id', $organization_id);	
			$this->db->where_not_in('t_trip_status','session_out'); 
			$this->db->where($where);  
			$this->db->order_by('t_id','desc');
			$query = $this->db->get();
			$tripdata= $query->result_array();
		}else{
			$tripdata = $this->db->select('*')->from('trips')->where($where)->where_not_in('t_trip_status','session_out')->order_by('t_id','desc')->get()->result_array();
		}
		if(!empty($tripdata)) {
			foreach ($tripdata as $key => $tripdataval) {
				$newtripdata[$key] = $tripdataval;
				$newtripdata[$key]['t_customer_details'] =  $this->db->select('*')->from('customers')->where('c_id',$tripdataval['t_customer_id'])->get()->row();
				$newtripdata[$key]['t_vechicle_details'] =  $this->db->select('*')->from('vehicles')->where('v_id',$tripdataval['t_vechicle'])->get()->row();
				$newtripdata[$key]['t_driver_details'] =   $this->db->select('*')->from('drivers')->where('d_id',$tripdataval['t_driver'])->get()->row();
			}
			return $newtripdata;
		} else 
		{
			return array();
		}
	}

	//trip add from mobile
	public function add_from_mobile_trips($data) {
		$insertdata = $this->security->xss_clean($data,TRUE);
		$this->db->insert('trips',$insertdata);
		return $this->db->insert_id();
	} 
	//trip update from mobile
	public function upadte($data1,$t_id) {		
		$insertdata = $this->security->xss_clean($data1,TRUE);
		$this->db->where('t_id',$t_id); 
		$this->db->update('trips',$insertdata);    
		return $this->db->insert_id();
	} 
	//trip update from mobile
	public function upadtenotifiy($data1,$t_id) {
		$insertdata = $this->security->xss_clean($data1,TRUE);
		$drv=$data1['t_driver'];
		$ntrip=$data1['t_trip_status'];
		$array = array('n_trip_status' => $ntrip);
		$where_array=array("n_trip_id"=>$t_id, "n_driver_id"=>$drv);
		$this->db->where($where_array);
		$data=$this->db->update('notification',$array);	  

		$drv=$data1['t_driver'];
		$ntrip=$data1['t_trip_status'];
		$array = array('n_trip_status' => 'already_accepted');
		$this->db->where('n_driver_id !=', $drv);
		$this->db->where('n_trip_id ', $t_id);
		$this->db->update('notification',$array);   

	} 
	//trip update from mobile
	public function upadtedriver($data1) {
		$t_driver=$data1['t_driver'];
		$array = array( 'd_riding_status' => 'yes');
		$this->db->where('d_id',$t_driver);
		return $this->db->update('drivers',$array);		
	}
	//trip cancel from mobile
	public function usercancel($data1,$t_id) {		
		$data=$this->db->select('t_driver')->from('trips')->where('t_id',$t_id)->order_by('t_id','asc')->get()->row_array();
		if($data['t_driver']){
			$insertdata = $this->security->xss_clean($data1,TRUE);
			$cid=$data1['c_id'];
			$ntrip=$data1['t_trip_status'];
			$array = array('t_trip_status' => $ntrip,'cancelled_by'=>'user','t_driver_status'=>'cancel');
			$where_array=array("t_id"=>$t_id, "t_customer_id"=>$cid);
			$this->db->where($where_array);
			$this->db->update('trips',$array);

			$ntrip=$data1['t_trip_status'];
			$array = array('n_trip_status' => $ntrip);
			$where_array=array("n_trip_id"=>$t_id,"n_driver_id"=>$data['t_driver']);
			$this->db->where($where_array);
			$this->db->update('notification',$array);

			$array = array('d_riding_status' => 'no');
			$where_array=array("d_id"=>$data['t_driver']);
			$this->db->where($where_array);
			return $this->db->update('drivers',$array);
		}else{		
			$insertdata = $this->security->xss_clean($data1,TRUE);
			$cid=$data1['c_id'];
			$ntrip=$data1['t_trip_status']; 
			$array = array('t_trip_status' => $ntrip,'cancelled_by'=>'user','t_driver_status'=>'cancel');
			$where_array=array("t_id"=>$t_id, "t_customer_id"=>$cid);
			$this->db->where($where_array);
			$this->db->update('trips',$array);

			$ntrip=$data1['t_trip_status'];
			$array = array('n_trip_status' => $ntrip);
			$where_array=array("n_trip_id"=>$t_id);
			$this->db->where($where_array);
			return $this->db->update('notification',$array);		
		}

	} 
			//trip cancel from mobile 
	public function drivercancel($data1,$t_id) {  		
		$insertdata = $this->security->xss_clean($data1,TRUE);
		$did=$data1['t_driver'];
		$ntrip=$data1['t_driver_status'];
		$t_trip_status=$data1['t_trip_status'];
		$array = array('t_driver_status' => $ntrip,'t_trip_status' => 'cancelled','cancelled_by'=>'driver'); 
		$where_array=array("t_id"=>$t_id, "t_driver"=>$did);
		$this->db->where($where_array);
		$this->db->update('trips',$array);
		
		$ntrip=$data1['t_driver_status'];
		$array = array('n_trip_status' => $ntrip);
		$where_array=array("n_trip_id"=>$t_id,"n_driver_id"=>$did);
		$this->db->where($where_array);
		$this->db->update('notification',$array);

		$array = array('n_trip_status' => 'cancel'); 
		$this->db->where('n_driver_id !=', $did);
		$this->db->where('n_trip_id ', $t_id);
		$this->db->update('notification',$array); 
		
		$array = array('d_riding_status' =>'no');
		$where_array=array("d_id"=>$did);
		$this->db->where($where_array);
		return $this->db->update('drivers',$array);
	}
	public function get_User_data($t_id){
		$this->db->select("*,customers.device_token as c_device_token,drivers.device_token as d_device_token");
		$this->db->from('trips');
		$this->db->join('drivers', 'drivers.d_id=trips.t_driver');
		$this->db->join('customers', 'customers.c_id=trips.t_customer_id');
		$this->db->join('vehicles', 'vehicles.v_driver_id=drivers.d_id');
		$this->db->where('trips.t_id',$t_id);
		$query = $this->db->get();
		$reuslt_data= $query->row_array();
		if($reuslt_data){
			return $reuslt_data;
		}else{

		}
	}


} 