<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Drivers extends CI_Controller {

	 function __construct()
     {
          parent::__construct();
          $this->load->database();
          $this->load->model('drivers_model');
		  $this->load->model('comman_model');
          $this->load->helper(array('form', 'url','string'));
          $this->load->library('form_validation');
          $this->load->library('session');
           $this->load->library("pagination");

     }

	public function index()
	{
		$data['driverslist'] = $this->drivers_model->getall_drivers();
		$this->template->template_render('drivers_management',$data);
	}
	// public function index()
	// {
	// 	  $config = array();
 //        $config["base_url"] = base_url() . "drivers/index";
 //        $config["total_rows"] = $this->drivers_model->get_count();
 //        $config["per_page"] = 4;
 //        $config["uri_segment"] = 3;

 //        $this->pagination->initialize($config);

 //        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

 //        $data["links"] = $this->pagination->create_links();

        

 //        $data['driverslist'] = $this->drivers_model->getall_drivers($config["per_page"], $page);
	// 	// $data['driverslist'] = $this->drivers_model->getall_drivers();
	// 	$this->template->template_render('drivers_management',$data);
	// }
	public function adddrivers()
	{
		$this->template->template_render('drivers_add');
	}
	public function insertdriver()
	{
		$this->form_validation->set_rules('d_licenseno','License Number','required|trim|is_unique[vehicles.v_registration_no]');
		$this->form_validation->set_message('is_unique', '%s is already exist');
		$this->form_validation->set_rules('d_name','Name','required|trim');
		$this->form_validation->set_rules('d_mobile','Mobile','required|trim');
		$this->form_validation->set_rules('d_email','Email','required|trim');
		$this->form_validation->set_rules('d_password','Password','required|trim');
        $this->form_validation->set_rules('d_address', 'Address', 'required|trim');
		$this->form_validation->set_rules('d_age','Age','required|trim');
		$this->form_validation->set_rules('d_licenseno','License Number','required|trim');
		$this->form_validation->set_rules('d_license_expdate','License Exp Date','required|trim');
		$this->form_validation->set_rules('d_total_exp','Total Experiance','required|trim');
		$this->form_validation->set_rules('d_doj','Date of Joining','required|trim');
		$testxss = xssclean($_POST);
		if($this->form_validation->run()==TRUE && $testxss){
			$response = $this->drivers_model->add_drivers($this->input->post());
			if($response) {
				$email_id=$this->input->post('d_email');
				$d_password=$this->input->post('d_password');
				$d_name=$this->input->post('d_name');

				
				$subject="Volta Credentials";

				$this->load->model('email_model');	
				$gettemplate = $this->db->select('*')->from('email_template')->where('et_name','driver')->get()->result_array();

				$emailcontent = $gettemplate[0]['et_body'];
				$value = 'Dear '.$d_name.'<br><br><b>User Id :</b> '.$email_id .' <br><b>Password : </b> ' . $d_password. ' <br><br> ';
				$body = str_replace('{{Volta Credentials}}', $value, $emailcontent);
				$body=$value;

				$email = $this->email_model->sendemail($email_id,$subject,$body);  
				$this->session->set_flashdata('successmessage', 'New driver added successfully..');
			  	redirect('drivers'); 
			}

		} else
		{
			$errormsg = validation_errors();
			if(!$testxs) {
				$errormsg = 'Error! Your input are not allowed.Please try again';
			}
			$this->session->set_flashdata('warningmessage',$errormsg);
			redirect('drivers/adddrivers');
		}
	}
	public function editdriver()
	{
		$d_id = $this->uri->segment(3);
		$data['driverdetails'] = $this->drivers_model->get_driverdetails($d_id);
		$this->template->template_render('drivers_add',$data);
	}
	public function viewdriver()
	{ 
		$d_id = $this->uri->segment(3);
		$data['driverdetails'] = $this->drivers_model->get_driverdetails($d_id); 
		
		$where_data=array('driver_id'=>$d_id,'document_name'=>'rc_front_file');
		$data['rc_front_file'] = $this->comman_model->get_data_by_row('drivers_documents',$where_data);
		
		$rc_back_where_data=array('driver_id'=>$d_id,'document_name'=>'rc_back_file');
		$data['rc_back_file'] = $this->comman_model->get_data_by_row('drivers_documents',$rc_back_where_data);
		
		$dl_front_where_data=array('driver_id'=>$d_id,'document_name'=>'dl_front_file');
		$data['dl_front_file'] = $this->comman_model->get_data_by_row('drivers_documents',$dl_front_where_data);
		
		$where_data=array('driver_id'=>$d_id,'document_name'=>'dl_back_file');
		$data['dl_back_file'] = $this->comman_model->get_data_by_row('drivers_documents',$where_data);
		//get file
		$this->template->template_render('driver_view',$data);
		
	}

	public function updatedriver()
	{
		$testxss = xssclean($_POST);
		if($testxss){
			$response = $this->drivers_model->edit_driver($this->input->post());
				if($response) {
					$driver_id=$this->input->post('d_id');
					$d_is_active=$this->input->post('d_is_active');
					if($d_is_active == '1'){
						$data=array('d_id'=>$driver_id);
						$user_data = $this->comman_model->get_data_by_row('drivers',$data);
						$device_id=$user_data['device_token']; 
						$title='Successfully Approved';
						$message='Congratulations Successfully Approved Driver Account and Start Your Ride';
						$this->comman_model->fcm_notification($device_id,$title,$message);
						$this->session->set_flashdata('successmessage', 'Driver updated successfully..');
				   		 redirect('drivers');
					}else{
						$this->session->set_flashdata('error', 'Unable to Approve');
				    	redirect('drivers');
					}
					
				} else
				{
					$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				    redirect('drivers');
				}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('drivers');
		}
	}

	 public function d_feedback()
	{
		$data['feedbacklist'] = $this->drivers_model->getall_feedback();

		$this->template->template_render('feedback_drivers',$data);
	}
	public function feedback_driver_view()
	{
		
		$fd_id = $this->uri->segment(3);
		$data['feedbacklist'] = $this->drivers_model->get_feedback($fd_id);
	
		$this->template->template_render('feedback_drivers_view',$data);
	}
}
