<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends CI_Controller {

	function __construct()
	{
		  parent::__construct();
		  $this->load->database();
		  $this->load->model('user_model');
		  $this->load->helper(array('form', 'url','string'));
		  $this->load->library('form_validation');
		  $this->load->library('session');
		  $this->load->model('comman_model');   
	}
	public function index()
	{
		$data['userlist'] = $this->user_model->getall_user();
		$data['organization_id']=$this->session->userdata['session_data']['organization_id'];
		$this->template->template_render('user_management',$data);
	}
	public function adduser()
	{
		$organization_id=$this->session->userdata['session_data']['organization_id'];
		$data['organization_id']=$organization_id;
		if($organization_id  == "0"){
			$data_where=array("org_isactive"=>'1');
		$data['organizationlist'] = $this->comman_model->get_data_where('organization',$data_where);
		}else{
			$data_where=$organization_id;
			$data['organizationlist']= $this->db->select('*')->from('organization')->where('org_id',$data_where)->where('org_isactive',1)->get()->result_array();
		}
	
		$this->template->template_render('user_add',$data);
	}
	
	public function insertuser() 
	{
		if(isset($_POST)){
			$response = $this->user_model->add_user($this->input->post());
			if($response['count']){
				$data=$this->input->post();
				//$password=$data['basic']['u_password']
			   $u_id=$response['uid'];
				
			   $this->db->select("*");
			   $this->db->from('login');
			   $this->db->join('organization', 'organization.org_id=login.organization_id');
			   $this->db->where('login.u_id',$u_id);
			   $query = $this->db->get();
			   $org_data= $query->row_array();
			   
				$org_code=$org_data['org_code'];
				$u_name=$org_data['u_name'];
				$u_email=$org_data['u_email'];
				$user_name=$org_data['u_username'];
				$user_name=$org_data['u_username'];
				$password=$data['basic']['u_password'];
				
				$subject="Volta Credentials";

				$this->load->model('email_model');	
				$gettemplate = $this->db->select('*')->from('email_template')->where('et_name','Organization')->get()->result_array();
				$emailcontent = $gettemplate[0]['et_body'];
				$value = 'Dear '.$u_name.'<br><br><b>Organization Code :</b> '.$org_code .'<br><b>User Name :</b> '.$user_name .' <br><b>Password : </b> ' . $password. ' <br><br> ';
				$body = str_replace('{{Volta Credentials}}', $value, $emailcontent);
				$body=$value;
				//$email = $this->email_model->sendemail($u_email,$subject,$body,$u_name);  
				$email = $this->email_model->sendemail($u_email,$subject,$body,$u_name);  
				$this->session->set_flashdata('successmessage', 'New user added successfully..');  
			} else {
				$this->session->set_flashdata('warningmessage', 'Error in creating new user..');
			}
			redirect('users');
		}else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('users');
		}
	}
	public function edituser()
	{
		$u_id = $this->uri->segment(3);
		$organization_id=$this->session->userdata['session_data']['organization_id'];
		$data['organization_id']=$organization_id;		
		if($organization_id  == "0"){
			$data_where=array("org_isactive"=>'1');
		$data['organizationlist'] = $this->comman_model->get_data_where('organization',$data_where);
		$data['userdetails'] = $this->user_model->get_userdetails($u_id);
		}else{
			$data_where=$organization_id;
			$data['organizationlist']= $this->db->select('*')->from('organization')->where('org_id',$data_where)->where('org_isactive',1)->get()->result_array();
			$data['userdetails'] = $this->user_model->get_userdetails($u_id);
		}
		
		$this->template->template_render('user_add',$data);
	}

	public function updateuser()
	{
		if(isset($_POST)){
			$response = $this->user_model->update_user($this->input->post());
				if($response) {
					$this->session->set_flashdata('successmessage', 'user updated successfully..');
				    redirect('users');
				} else
				{
					$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				    redirect('users');
				}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('users');
		}
	}
	
	public function profile(){
		$data['userlist'] = $this->user_model->getall_user_by_org();
		$this->template->template_render('profile',$data); 
	}
	public function profile_update(){
			$org_id = $this->input->post('org_id');
			$filesCount = count($_FILES['logo']['name']);
					if(@$filesCount != 0)
					{									
						//echo $i;
							//$i=$key;
							$_FILES['file']['name']     = $_FILES['logo']['name'];
							$_FILES['file']['type']     = $_FILES['logo']['type'];
							$_FILES['file']['tmp_name'] = $_FILES['logo']['tmp_name'];
							$_FILES['file']['error']     = $_FILES['logo']['error'];
							$_FILES['file']['size']     = $_FILES['logo']['size'];
							
							//File upload configuration photographs
							$uploadPath = 'assets/uploads/';
							$config['upload_path'] = $uploadPath;
							$config['allowed_types'] = 'jpg|jpeg|png'; 
							// $config['encrypt_name'] = TRUE;
							
							// Load and initialize upload library 
							$this->load->library('upload', $config);
							$this->upload->initialize($config); 
							
							// Upload file to server
							if($this->upload->do_upload('file'))
							{	
								//echo 'Successfully update';
								$fileData = $this->upload->data();
								$where=array('org_id'=>$org_id);
								$data=array('logo'=>$fileData['file_name']);
								$update_data=$this->comman_model->update('organization', $where, $data);
								$this->session->set_flashdata('successmessage', 'Update Successfully successfully..');
								redirect('dashboard');
								}else{
									$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
									redirect('dashboard');
							}
						}else{
						echo "there is no file uploaded";
					}
	}
}
